/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.hibernate;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressCampaignStatus;
import org.squashtest.tm.internal.domain.report.query.QueryOperator;
import org.squashtest.tm.internal.domain.report.query.hibernate.ReportCriterion;

public class IsRunningCampaignCriterion
extends ReportCriterion {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsRunningCampaignCriterion.class);

    public IsRunningCampaignCriterion() {
        this.setOperator(QueryOperator.COMPARATOR_SPECIAL);
        this.setParamClass(ExProgressCampaignStatus.class);
    }

    public IsRunningCampaignCriterion(String criterionName, String attributePath) {
        this.setCriterionName(criterionName);
        this.setAttributePath(attributePath);
    }

    @Override
    public Criterion makeCriterion() {
        try {
            Object result = null;
            Object[] values = this.getParameters();
            if (values != null && values.length > 0) {
                ExProgressCampaignStatus status = ExProgressCampaignStatus.valueOf(values[0].toString());
                DetachedCriteria subQuery = DetachedCriteria.forClass(Campaign.class, (String)"campaigns2").createCriteria("iterations").createCriteria("testPlans", "tps").add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"tps.executionStatus", (Object)ExecutionStatus.READY)).add((Criterion)Restrictions.eq((String)"tps.executionStatus", (Object)ExecutionStatus.RUNNING))).setProjection((Projection)Projections.projectionList().add((Projection)Property.forName((String)"campaigns2.id")));
                result = status == ExProgressCampaignStatus.CAMPAIGN_RUNNING ? Property.forName((String)"campaigns.id").in(subQuery) : (status == ExProgressCampaignStatus.CAMPAIGN_OVER ? Property.forName((String)"campaigns.id").notIn(subQuery) : null);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

