/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.dto;

import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressIterationDto;

public class ExProgressTestPlanDto {
    private String testCaseName;
    private ExecutionStatus executionStatus;
    private ExProgressIterationDto iteration;
    private String testSuitesNames;

    public ExProgressTestPlanDto() {
    }

    public ExProgressTestPlanDto(String testCaseName, ExecutionStatus executionStatus) {
        this.testCaseName = testCaseName;
        this.executionStatus = executionStatus;
    }

    public ExProgressIterationDto getIteration() {
        return this.iteration;
    }

    public void setIteration(ExProgressIterationDto iteration) {
        this.iteration = iteration;
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public void setTestCaseName(String testCaseName) {
        this.testCaseName = testCaseName;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public String getTestSuitesNames() {
        return this.testSuitesNames;
    }

    public void setTestSuitesNames(String testSuitesNames) {
        this.testSuitesNames = testSuitesNames;
    }

    public ExProgressTestPlanDto fillBasicInfo(IterationTestPlanItem testPlan) {
        String reference;
        this.testCaseName = testPlan.isTestCaseDeleted() ? null : ((reference = testPlan.getReferencedTestCase().getReference()) != null && reference.isEmpty() ? (testPlan.isTestCaseDeleted() ? null : testPlan.getReferencedTestCase().getName()) : (testPlan.isTestCaseDeleted() ? null : String.valueOf(reference) + " - " + testPlan.getReferencedTestCase().getName()));
        this.testSuitesNames = this.buildTestSuitesNames(testPlan);
        this.executionStatus = testPlan.getExecutionStatus();
        return this;
    }

    private String buildTestSuitesNames(IterationTestPlanItem testPlanItem) {
        String prefix = "";
        StringBuilder result = new StringBuilder();
        for (TestSuite testSuite : testPlanItem.getTestSuites()) {
            result.append(prefix);
            prefix = ", ";
            result.append(testSuite.getName());
        }
        return result.toString();
    }
}

