/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.query.hibernate;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.squashtest.tm.internal.domain.report.query.ReportQuery;
import org.squashtest.tm.internal.domain.report.query.ReportQueryFlavor;
import org.squashtest.tm.internal.domain.report.query.hibernate.HibernateQueryFlavor;
import org.squashtest.tm.internal.domain.report.query.hibernate.ReportCriterion;
import org.squashtest.tm.plugin.report.std.service.DataFilteringService;

public abstract class HibernateReportQuery
implements ReportQuery {
    private final ReportQueryFlavor flavor = new HibernateQueryFlavor();
    protected Map<String, ReportCriterion> criterions = new HashMap<String, ReportCriterion>();
    private DataFilteringService filterService;

    @Override
    public ReportQueryFlavor getFlavor() {
        return this.flavor;
    }

    @Override
    public void setCriterion(String name, Object ... values) {
        ReportCriterion criterion = this.criterions.get(name);
        if (criterion == null) {
            throw new IllegalArgumentException("parameter " + name + " does not exists for query " + this.getClass().getSimpleName());
        }
        criterion.setParameter(values);
    }

    @Override
    public void setDataFilteringService(DataFilteringService service) {
        this.filterService = service;
    }

    protected DataFilteringService getDataFilteringService() {
        return this.filterService;
    }

    protected Map<String, ReportCriterion> getCriterions() {
        return this.criterions;
    }

    @Override
    public Collection<String> getCriterionNames() {
        return this.criterions.keySet();
    }

    @Override
    public boolean isCriterionExists(String name) {
        return this.criterions.get(name) != null;
    }

    @Override
    public Object[] getValue(String key) {
        ReportCriterion criterion = this.criterions.get(key);
        if (criterion != null) {
            return criterion.getParameters();
        }
        return null;
    }

    protected DetachedCriteria addCriterion(DetachedCriteria criteria, String criterionName) {
        Criterion hibCriterion;
        ReportCriterion criterion = this.criterions.get(criterionName);
        if (criterion != null && (hibCriterion = criterion.makeCriterion()) != null) {
            criteria.add(hibCriterion);
        }
        return criteria;
    }

    public abstract DetachedCriteria createHibernateQuery();

    public abstract List<?> doInSession(Session var1);

    public abstract List<?> convertToDto(List<?> var1);
}

