/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.query.hibernate;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.internal.domain.report.query.ReportQuery;
import org.squashtest.tm.internal.domain.report.query.ReportQueryFlavor;
import org.squashtest.tm.internal.domain.report.query.UnsupportedFlavorException;
import org.squashtest.tm.internal.domain.report.query.hibernate.HibernateQueryFlavor;
import org.squashtest.tm.internal.domain.report.query.hibernate.HibernateReportQuery;
import org.squashtest.tm.internal.repository.ReportQueryDao;

@Repository
public class HibernateReportQueryDao
implements ReportQueryDao {
    @PersistenceContext
    private EntityManager em;
    private final ReportQueryFlavor flavor = new HibernateQueryFlavor();

    private Session currentSession() {
        return (Session)this.em.unwrap(Session.class);
    }

    @Override
    public boolean doesSupportFlavor(ReportQueryFlavor flavor) {
        return this.flavor.getClass() == flavor.getClass();
    }

    @Override
    public List<?> executeQuery(ReportQuery query) throws UnsupportedFlavorException {
        if (!this.doesSupportFlavor(query.getFlavor())) {
            throw new UnsupportedFlavorException("Error : ReportQueryDao implementation does not support queries of class " + query.getClass().getName());
        }
        HibernateReportQuery hibQuery = (HibernateReportQuery)query;
        DetachedCriteria dCriteria = hibQuery.createHibernateQuery();
        List<?> result = dCriteria != null ? this.executeDetachedCriteria(dCriteria) : hibQuery.doInSession(this.currentSession());
        return hibQuery.convertToDto(result);
    }

    private List<?> executeDetachedCriteria(DetachedCriteria dCriteria) {
        Session session = this.currentSession();
        Criteria criteria = dCriteria.getExecutableCriteria(session);
        return criteria.list();
    }

    @Override
    public ReportQueryFlavor[] getSupportedFlavors() {
        return new ReportQueryFlavor[]{this.flavor};
    }
}

