/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.std.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.internal.domain.report.common.hibernate.HibernateExecutionProgressQuery;
import org.squashtest.tm.internal.domain.report.query.hibernate.HibernateReportQuery;
import org.squashtest.tm.plugin.report.std.query.LegacyQueryAdapter;

public class ExecutionProgressQueryAdapter
extends LegacyQueryAdapter<HibernateExecutionProgressQuery> {
    @Inject
    private Provider<HibernateExecutionProgressQuery> legacyQueryProvider;
    static final String CAMPAIGN_IDS = "campaignIds";
    static final String LEGACY_CAMPAIGN_IDS = "campaignIds[]";
    static final String CAMPAIGN_SELECTION_MODE = "campaignSelectionMode";
    static final String MILESTONE_IDS = "milestones";

    @Override
    protected void processNonStandardCriteria(Map<String, Criteria> criteria, HibernateReportQuery legacyQuery) {
        Criteria selMode = criteria.get(CAMPAIGN_SELECTION_MODE);
        if ("EVERYTHING".equals(selMode.getValue())) {
            this.setNoCampaignIds(legacyQuery);
        } else if ("MILESTONE_PICKER".equals(selMode.getValue())) {
            Criteria mIdsCrit = criteria.get(MILESTONE_IDS);
            Collection values = (Collection)mIdsCrit.getValue();
            legacyQuery.setCriterion(MILESTONE_IDS, values.toArray());
        } else {
            Criteria idsCrit = criteria.get(CAMPAIGN_IDS);
            HashSet nodesIds = new HashSet();
            this.addCampaignIds(idsCrit, nodesIds, "campaigns");
            this.addCampaignIds(idsCrit, nodesIds, "campaign-folders");
            legacyQuery.setCriterion(LEGACY_CAMPAIGN_IDS, nodesIds.toArray());
        }
    }

    private void addCampaignIds(Criteria idsCrit, Collection nodesIds, String nodeType) {
        Collection campaignIds = (Collection)((Map)idsCrit.getValue()).get(nodeType);
        if (campaignIds != null) {
            nodesIds.addAll(campaignIds);
        }
    }

    private void setNoCampaignIds(HibernateReportQuery legacyQuery) {
        legacyQuery.setCriterion(LEGACY_CAMPAIGN_IDS, null);
    }

    @Override
    protected boolean isStandardCriteria(String criterionName) {
        boolean isStd = true;
        switch (criterionName) {
            case "campaignSelectionMode": 
            case "milestones": 
            case "campaignIds": {
                isStd = false;
                break;
            }
            default: {
                isStd = true;
            }
        }
        return isStd;
    }

    @Override
    protected Provider<HibernateExecutionProgressQuery> getLegacyQueryProvider() {
        return this.legacyQueryProvider;
    }
}

