/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.internal.domain.report.common.dto;

import java.util.List;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.internal.domain.report.common.dto.ExProgressCampaignStatus;

public abstract class ExProgressAbstractDto {
    protected String name;
    protected Integer iCountStatusReady = 0;
    protected Integer iCountStatusRunning = 0;
    protected Integer iCountStatusBloqued = 0;
    protected Integer iCountStatusFailure = 0;
    protected Integer iCountStatusSuccess = 0;
    protected Integer iCountStatusUntestable = 0;
    protected Integer iCountStatusSettled = 0;

    public ExProgressAbstractDto() {
    }

    public ExProgressAbstractDto(List<IterationTestPlanItem> testPlans) {
        this.fillStatusInfos(testPlans);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getiCountStatusReady() {
        return this.iCountStatusReady;
    }

    public void setiCountStatusReady(Integer iCountStatusReady) {
        this.iCountStatusReady = iCountStatusReady;
    }

    public Integer getiCountStatusRunning() {
        return this.iCountStatusRunning;
    }

    public void setiCountStatusRunning(Integer iCountStatusRunning) {
        this.iCountStatusRunning = iCountStatusRunning;
    }

    public Integer getiCountStatusBloqued() {
        return this.iCountStatusBloqued;
    }

    public void setiCountStatusBloqued(Integer iCountStatusBloqued) {
        this.iCountStatusBloqued = iCountStatusBloqued;
    }

    public Integer getiCountStatusFailure() {
        return this.iCountStatusFailure;
    }

    public void setiCountStatusFailure(Integer iCountStatusFailure) {
        this.iCountStatusFailure = iCountStatusFailure;
    }

    public Integer getiCountStatusSettled() {
        return this.iCountStatusSettled;
    }

    public void setiCountStatusSettled(Integer iCountStatusSettled) {
        this.iCountStatusSettled = iCountStatusSettled;
    }

    public Integer getiCountStatusSuccess() {
        return this.iCountStatusSuccess;
    }

    public void setiCountStatusSuccess(Integer iCountStatusSuccess) {
        this.iCountStatusSuccess = iCountStatusSuccess;
    }

    public Integer getiCountStatusUntestable() {
        return this.iCountStatusUntestable;
    }

    public void setiCountStatusUntestable(Integer iCountStatusUntestable) {
        this.iCountStatusUntestable = iCountStatusUntestable;
    }

    public Integer getNumberTestCase() {
        return this.iCountStatusReady + this.iCountStatusRunning + this.iCountStatusBloqued + this.iCountStatusFailure + this.iCountStatusSettled + this.iCountStatusSuccess + this.iCountStatusUntestable;
    }

    public float getfPercentageStatusReady() {
        Integer total = this.getNumberTestCase();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.getiCountStatusReady().intValue() / (float)total.intValue();
    }

    public float getfPercentageStatusRunning() {
        Integer total = this.getNumberTestCase();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.getiCountStatusRunning().intValue() / (float)total.intValue();
    }

    public float getfPercentageStatusBloqued() {
        Integer total = this.getNumberTestCase();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.getiCountStatusBloqued().intValue() / (float)total.intValue();
    }

    public float getfPercentageStatusFailure() {
        Integer total = this.getNumberTestCase();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.getiCountStatusFailure().intValue() / (float)total.intValue();
    }

    public float getfPercentageStatusSuccess() {
        Integer total = this.getNumberTestCase();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.getiCountStatusSuccess().intValue() / (float)total.intValue();
    }

    public float getfPercentageStatusUntestable() {
        Integer total = this.getNumberTestCase();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.getiCountStatusUntestable().intValue() / (float)total.intValue();
    }

    public float getfPercentageStatusSettled() {
        Integer total = this.getNumberTestCase();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.getiCountStatusSettled().intValue() / (float)total.intValue();
    }

    public float getfPercentageProgress() {
        return this.getfPercentageStatusBloqued() + this.getfPercentageStatusUntestable() + this.getfPercentageStatusFailure() + this.getfPercentageStatusSuccess() + this.getfPercentageStatusSettled();
    }

    private void fillStatusInfos(List<IterationTestPlanItem> testPlan) {
        for (IterationTestPlanItem testPlanItem : testPlan) {
            switch (testPlanItem.getExecutionStatus()) {
                case READY: {
                    this.iCountStatusReady = this.iCountStatusReady + 1;
                    break;
                }
                case RUNNING: {
                    this.iCountStatusRunning = this.iCountStatusRunning + 1;
                    break;
                }
                case BLOCKED: {
                    this.iCountStatusBloqued = this.iCountStatusBloqued + 1;
                    break;
                }
                case FAILURE: {
                    this.iCountStatusFailure = this.iCountStatusFailure + 1;
                    break;
                }
                case SUCCESS: {
                    this.iCountStatusSuccess = this.iCountStatusSuccess + 1;
                    break;
                }
                case UNTESTABLE: {
                    this.iCountStatusUntestable = this.iCountStatusUntestable + 1;
                    break;
                }
                case SETTLED: {
                    this.iCountStatusSettled = this.iCountStatusSettled + 1;
                }
            }
        }
    }

    public ExProgressCampaignStatus getStatus() {
        if (this.iCountStatusBloqued + this.iCountStatusFailure + this.iCountStatusSuccess + this.iCountStatusUntestable == this.getNumberTestCase()) {
            return ExProgressCampaignStatus.CAMPAIGN_OVER;
        }
        return ExProgressCampaignStatus.CAMPAIGN_RUNNING;
    }

    public void fillStatusInfosWithChildren(List<? extends ExProgressAbstractDto> containedExProgressDto) {
        for (ExProgressAbstractDto exProgressAbstractDto : containedExProgressDto) {
            this.iCountStatusBloqued = this.iCountStatusBloqued + exProgressAbstractDto.getiCountStatusBloqued();
            this.iCountStatusFailure = this.iCountStatusFailure + exProgressAbstractDto.getiCountStatusFailure();
            this.iCountStatusReady = this.iCountStatusReady + exProgressAbstractDto.getiCountStatusReady();
            this.iCountStatusRunning = this.iCountStatusRunning + exProgressAbstractDto.getiCountStatusRunning();
            this.iCountStatusSuccess = this.iCountStatusSuccess + exProgressAbstractDto.getiCountStatusSuccess();
            this.iCountStatusUntestable = this.iCountStatusUntestable + exProgressAbstractDto.getiCountStatusUntestable();
            this.iCountStatusSettled = this.iCountStatusSettled + exProgressAbstractDto.getiCountStatusSettled();
        }
    }
}

