/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageProjectBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageCampaignProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageProcessService;

public class QuaCoverageProcess {
    private final List<QuaCoverageProjectBean> projectBeans = new ArrayList<QuaCoverageProjectBean>();
    private Collection<Integer> milestoneIds;
    private final QuaCoverageProcessService quaCoverageProcessService;

    public QuaCoverageProcess(QuaCoverageProcessService quaCoverageProcessService) {
        this.quaCoverageProcessService = quaCoverageProcessService;
    }

    public List<QuaCoverageProjectBean> getProjects(List<Long> projectIds) {
        for (Long id : projectIds) {
            List<QuaCoverageProjectBean> quaCoverageProjectBeans = this.quaCoverageProcessService.getProject(id);
            this.addCampaignsToProjectBean(quaCoverageProjectBeans);
        }
        return this.projectBeans;
    }

    private void addCampaignsToProjectBean(List<QuaCoverageProjectBean> result) {
        result.forEach(projectBean -> {
            QuaCoverageCampaignProcess campaignProcess = new QuaCoverageCampaignProcess(this.quaCoverageProcessService);
            campaignProcess.setMilestoneIds(this.milestoneIds);
            projectBean.setCampaigns(campaignProcess.getCampaigns(projectBean.getProjectId()));
            List<String> disabledExecutionStatus = this.quaCoverageProcessService.getDisabledExecutionStatus(projectBean.getProjectId());
            projectBean.setDisabledExecutionStatus(disabledExecutionStatus);
            this.projectBeans.add((QuaCoverageProjectBean)projectBean);
        });
    }

    public void setMilestoneIds(Collection<Integer> milestoneIds) {
        this.milestoneIds = milestoneIds;
    }
}

