/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageIterationBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageProcessService;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageTestSuiteProcess;

public class QuaCoverageIterationProcess {
    private List<QuaCoverageIterationBean> iterationBeans;
    private final QuaCoverageProcessService quaCoverageProcessService;

    public QuaCoverageIterationProcess(QuaCoverageProcessService quaCoverageProcessService) {
        this.quaCoverageProcessService = quaCoverageProcessService;
    }

    public List<QuaCoverageIterationBean> getIterations(Long campaignId) {
        this.iterationBeans = new ArrayList<QuaCoverageIterationBean>();
        List<QuaCoverageIterationBean> iterations = this.quaCoverageProcessService.getIterationsByCampaign(campaignId);
        this.addTestSuitesToIterationBean(iterations);
        return this.iterationBeans;
    }

    private void addTestSuitesToIterationBean(List<QuaCoverageIterationBean> iterations) {
        iterations.forEach(iteration -> {
            iteration.setRequirements(this.quaCoverageProcessService.getRequirementsByIteration(iteration.getIterationId()));
            QuaCoverageTestSuiteProcess testSuiteProcess = new QuaCoverageTestSuiteProcess(this.quaCoverageProcessService);
            iteration.setTestSuites(testSuiteProcess.getTestSuites(iteration.getIterationId()));
            this.iterationBeans.add((QuaCoverageIterationBean)iteration);
        });
    }
}

