/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageCampaignBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageIterationProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageProcessService;

public class QuaCoverageCampaignProcess {
    private List<QuaCoverageCampaignBean> campaignBeans;
    private Collection<Integer> milestoneIds;
    private final QuaCoverageProcessService quaCoverageProcessService;

    public QuaCoverageCampaignProcess(QuaCoverageProcessService quaCoverageProcessService) {
        this.quaCoverageProcessService = quaCoverageProcessService;
    }

    public List<QuaCoverageCampaignBean> getCampaigns(Long projectId) {
        this.campaignBeans = new ArrayList<QuaCoverageCampaignBean>();
        Map<Long, String> campaignMap = this.milestoneIds == null ? this.quaCoverageProcessService.getCampaignsByProject(projectId) : this.quaCoverageProcessService.getCampaignsByProjectAndMilestone(projectId, this.milestoneIds);
        this.addIterationsToCampaignBean(campaignMap);
        return this.campaignBeans;
    }

    private void addIterationsToCampaignBean(Map<Long, String> campaignMap) {
        campaignMap.forEach((campaignId, name) -> {
            QuaCoverageCampaignBean campaignBean = new QuaCoverageCampaignBean();
            campaignBean.setCampaignId((Long)campaignId);
            campaignBean.setCampaignName((String)name);
            campaignBean.setRequirements(this.quaCoverageProcessService.getRequirementsByCampaign((Long)campaignId));
            QuaCoverageIterationProcess iterationProcess = new QuaCoverageIterationProcess(this.quaCoverageProcessService);
            campaignBean.setIterations(iterationProcess.getIterations(campaignBean.getCampaignId()));
            this.campaignBeans.add(campaignBean);
        });
    }

    public void setMilestoneIds(Collection<Integer> milestoneIds) {
        this.milestoneIds = milestoneIds;
    }
}

