/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage;

import jakarta.inject.Named;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;
import org.squashtest.tm.api.report.BasicReport;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.ReportPlugin;
import org.squashtest.tm.api.report.ReportView;
import org.squashtest.tm.api.report.StandardReportCategory;
import org.squashtest.tm.api.report.StandardReportType;
import org.squashtest.tm.api.report.form.Input;
import org.squashtest.tm.api.report.form.RadioButtonsGroup;
import org.squashtest.tm.api.report.form.composite.MilestonePickerOption;
import org.squashtest.tm.api.report.form.composite.ProjectPickerOption;
import org.squashtest.tm.api.report.jasperreports.JasperReportsView;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.report.spring.view.jasperreports.JasperReportsExtMultiFormatView;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageProcessService;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageQuery;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Configuration
public class QualitativeCoverageReportConfig {
    private final PermissionEvaluationService permissionService;
    private final QuaCoverageProcessService quaCoverageProcessService;
    private final MessageSource messageSource;

    public QualitativeCoverageReportConfig(PermissionEvaluationService permissionService, QuaCoverageProcessService quaCoverageProcessService, MessageSource messageSource) {
        this.permissionService = permissionService;
        this.quaCoverageProcessService = quaCoverageProcessService;
        this.messageSource = messageSource;
    }

    @Bean(name={"squash.tm.report.qualitativecoverage"})
    public ReportPlugin qualitativeCoverageReportPlugin(BasicReport qualitativeCoverage) {
        ReportPlugin plugin = new ReportPlugin();
        plugin.setReports(new Report[]{qualitativeCoverage});
        return plugin;
    }

    @Bean
    public BasicReport qualitativeCoverage(RadioButtonsGroup quaRequirementsSelectionMode, JasperReportsView dashboardView, JasperReportsView listView) {
        BasicReport report = new BasicReport();
        report.setCategory(StandardReportCategory.EXECUTION_PHASE);
        report.setType(StandardReportType.PROGRESS_FOLLOWUP);
        report.setLabelKey("report.qualitativecoverage.name");
        report.setDescriptionKey("report.qualitativecoverage.description");
        report.setViews(new ReportView[]{dashboardView, listView});
        report.setForm(new Input[]{quaRequirementsSelectionMode});
        return report;
    }

    @Bean
    public JasperReportsView dashboardView(QuaCoverageQuery qualitativeCoverageQuery, JasperReportsExtMultiFormatView qualitativeCoverageOverview) {
        JasperReportsView dashboardView = new JasperReportsView();
        dashboardView.setLabelKey("report.qualitativecoverage.view.title.tabularview");
        dashboardView.setFormats(new String[]{"pdf", "html"});
        dashboardView.setQuery((ReportQuery)qualitativeCoverageQuery);
        dashboardView.setSpringView((View)qualitativeCoverageOverview);
        return dashboardView;
    }

    @Bean
    public JasperReportsView listView(QuaCoverageQuery qualitativeCoverageQuery, JasperReportsExtMultiFormatView qualitativeCoverageList) {
        JasperReportsView listView = new JasperReportsView();
        listView.setLabelKey("report.qualitativecoverage.view.title.listview");
        listView.setFormats(new String[]{"pdf", "html", "xls", "csv"});
        listView.setQuery((ReportQuery)qualitativeCoverageQuery);
        listView.setSpringView((View)qualitativeCoverageList);
        return listView;
    }

    @Bean(name={"quaRequirementsSelectionMode"})
    public RadioButtonsGroup quaRequirementsSelectionMode(@Named(value="quaProjectPickerOption") ProjectPickerOption quaProjectPickerOption, @Named(value="quaMilestonePickerOption") MilestonePickerOption quaMilestonePickerOption) {
        RadioButtonsGroup quaRequirementsSelectionMode = new RadioButtonsGroup();
        quaRequirementsSelectionMode.setName("requirementsSelectionMode");
        quaRequirementsSelectionMode.setLabelKey("report.coverage.criteria.selectionMode.label");
        quaRequirementsSelectionMode.setRequired(true);
        quaRequirementsSelectionMode.setOptions(List.of(quaProjectPickerOption, quaMilestonePickerOption));
        quaRequirementsSelectionMode.setMessageSource(this.messageSource);
        return quaRequirementsSelectionMode;
    }

    @Bean(name={"quaProjectPickerOption"})
    public ProjectPickerOption quaProjectPickerOption() {
        ProjectPickerOption projectOption = new ProjectPickerOption();
        projectOption.setPickerName("projectIds");
        projectOption.setLabelKey("report.criteria.panel.perimeter.project.label");
        projectOption.setDefaultSelected(true);
        projectOption.setMessageSource(this.messageSource);
        return projectOption;
    }

    @Bean(name={"quaMilestonePickerOption"})
    public MilestonePickerOption quaMilestonePickerOption() {
        MilestonePickerOption milestoneOption = new MilestonePickerOption();
        milestoneOption.setLabelKey("report.criteria.panel.milestone.label");
        milestoneOption.setPickerLabelKey("report.criteria.panel.milestone.label");
        milestoneOption.setPickerName("milestones");
        milestoneOption.setMessageSource(this.messageSource);
        return milestoneOption;
    }

    @Bean
    public QuaCoverageQuery qualitativeCoverageQuery() {
        return new QuaCoverageQuery(this.permissionService, this.quaCoverageProcessService);
    }

    @Bean(name={"qualitativeCoverageOverview"})
    public JasperReportsExtMultiFormatView qualitativeCoverageOverview() {
        JasperReportsExtMultiFormatView view = new JasperReportsExtMultiFormatView();
        view.setUrl("classpath:jasperreports/qualitative-coverage-list.jasper");
        view.setReportDataKey("data");
        view.setReportFileName("Report-qualitative-coverage-overview");
        Properties subReportUrls = new Properties();
        subReportUrls.put("subReportListCampaigns", "classpath:jasperreports/qualitative-coverage-list-campaigns.jasper");
        subReportUrls.put("subReportListIterations", "classpath:jasperreports/qualitative-coverage-list-iterations.jasper");
        subReportUrls.put("subReportListTestSuites", "classpath:jasperreports/qualitative-coverage-list-test-suites.jasper");
        view.setSubReportUrls(subReportUrls);
        view.setExporterParameters(Map.of("net.sf.jasperreports.engine.export.JRHtmlExporterParameter.ZOOM_RATIO", Float.valueOf(1.4f)));
        return view;
    }

    @Bean(name={"qualitativeCoverageList"})
    public JasperReportsExtMultiFormatView qualitativeCoverageList() {
        JasperReportsExtMultiFormatView view = new JasperReportsExtMultiFormatView();
        view.setUrl("classpath:jasperreports/qualitative-coverage-table.jasper");
        view.setReportDataKey("data");
        view.setReportFileName("Report-qualitative-coverage-list");
        Properties subReportUrls = new Properties();
        subReportUrls.put("subReportTableCampaigns", "classpath:jasperreports/qualitative-coverage-table-campaigns.jasper");
        subReportUrls.put("subReportTableIterations", "classpath:jasperreports/qualitative-coverage-table-iterations.jasper");
        subReportUrls.put("subReportTableTestSuites", "classpath:jasperreports/qualitative-coverage-table-test-suites.jasper");
        subReportUrls.put("subReportTableRequirements", "classpath:jasperreports/qualitative-coverage-table-requirements.jasper");
        subReportUrls.put("subReportTableRequirements2", "classpath:jasperreports/qualitative-coverage-table-requirements.jasper");
        view.setSubReportUrls(subReportUrls);
        view.setExporterParameters(Map.of("net.sf.jasperreports.engine.export.JRHtmlExporterParameter.ZOOM_RATIO", Float.valueOf(1.6f), "net.sf.jasperreports.engine.export.JRHtmlExporterParameter.HTML_HEADER", "<style> td.vertical-text p {\n-moz-hyphens: none;\n-webkit-hyphens: none;\nword-break: keep-all;\nhyphens: auto;\nhyphenate: auto;\nword-break:none;\n transform:rotate(-90deg);\n transform-origin: 50% 50%;\n-moz-transform:rotate(-90deg);\n-moz-transform-origin: 50% 50%;\n-webkit-transform: rotate(-90deg);\n-webkit-transform-origin: 50% 50%;\n-o-transform: rotate(-90deg);\n-o-transform-origin:  50% 50%;\nfilter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);\n}\n</style>\n"));
        return view;
    }
}

