/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import jakarta.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageProjectBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageProcessService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component
public class QuaCoverageQuery
implements ReportQuery {
    private static final String CRIT_MILESTONES = "milestones";
    private static final String CRIT_PROJ_IDS = "projectIds";
    private static final String CRIT_PROJECT_PICKER = "PROJECT_PICKER";
    private PermissionEvaluationService permissionService;
    private QuaCoverageProcessService quaCoverageProcessService;

    @Inject
    public QuaCoverageQuery(PermissionEvaluationService permissionService, QuaCoverageProcessService quaCoverageProcessService) {
        this.permissionService = permissionService;
        this.quaCoverageProcessService = quaCoverageProcessService;
    }

    public QuaCoverageQuery() {
    }

    public void executeQuery(Map<String, Criteria> criteria, Map<String, Object> model) {
        List<Long> projectIds;
        QuaCoverageProcess projectProcess = new QuaCoverageProcess(this.quaCoverageProcessService);
        String mode = (String)criteria.get("requirementsSelectionMode").getValue();
        List milestoneIds = null;
        if (mode.equals(CRIT_PROJECT_PICKER)) {
            List projectIdsAsString = (List)criteria.get(CRIT_PROJ_IDS).getValue();
            projectIds = projectIdsAsString.stream().map(Long::parseLong).toList();
        } else {
            milestoneIds = (List)criteria.get(CRIT_MILESTONES).getValue();
            projectIds = this.quaCoverageProcessService.getProjectIds(milestoneIds);
        }
        List<Long> accessibleProjectIds = this.filterAccessibleProject(projectIds);
        projectProcess.setMilestoneIds(milestoneIds);
        List<QuaCoverageProjectBean> result = projectProcess.getProjects(accessibleProjectIds);
        if (milestoneIds != null) {
            Integer milestoneId = (Integer)milestoneIds.getFirst();
            String milestoneLabel = this.quaCoverageProcessService.getMilestoneLabel(milestoneId);
            model.put("milestoneLabel", milestoneLabel);
        }
        model.put("data", result);
    }

    private List<Long> filterAccessibleProject(List<Long> projectIds) {
        LinkedList<Long> filtered = new LinkedList<Long>();
        for (Long projectId : projectIds) {
            if (!this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "READ", projectId, "org.squashtest.tm.domain.project.Project")) continue;
            filtered.add(projectId);
        }
        return filtered;
    }
}

