/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Service;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Resource;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.ExecutionStatus;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageIterationBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageProjectBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageRequirementBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageTestSuiteBean;

@Service
public class QuaCoverageProcessService {
    public static final String COUNTS = "counts";
    public static final String RES_ID = "RES_ID";
    public static final String PROJECT_TYPE = "P";
    public static final String ID = "id";
    public static final String NAME = "NAME";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    public static final String UNTESTABLE = "untestable";
    public static final String BLOCKED = "blocked";
    public static final String SETTLED = "settled";
    public static final String RUNNING = "running";
    public static final String READY = "ready";
    public static final String REQUIREMENT_ID = "REQUIREMENT_ID";
    public static final String REQUIREMENT_NAME = "REQUIREMENT_NAME";
    public static final String REQUIREMENT_REF = "REQUIREMENT_REF";
    public static final String REQUIREMENT_VERSION_NUMBER = "REQUIREMENT_VERSION_NUMBER";
    public static final String CRITICALITY = "CRITICALITY";
    private final DSLContext dsl;

    @Inject
    protected QuaCoverageProcessService(DSLContext dsl) {
        this.dsl = dsl;
    }

    public Map<Long, String> getCampaignsByProject(Long projectId) {
        return this.dsl.selectDistinct((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).fetch().intoMap((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME);
    }

    public Map<Long, String> getCampaignsByProjectAndMilestone(Long projectId, Collection<Integer> milestoneIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.in(milestoneIds)).fetch().intoMap((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME);
    }

    public List<QuaCoverageRequirementBean> getRequirementsByCampaign(Long campaignId) {
        Table<?> success = this.campaignStatusSubquery(campaignId, SUCCESS, List.of(ExecutionStatus.SUCCESS, ExecutionStatus.WARNING));
        Table<?> failure = this.campaignStatusSubquery(campaignId, FAILURE, List.of(ExecutionStatus.FAILURE));
        Table<?> untestable = this.campaignStatusSubquery(campaignId, UNTESTABLE, List.of(ExecutionStatus.UNTESTABLE));
        Table<?> blocked = this.campaignStatusSubquery(campaignId, BLOCKED, List.of(ExecutionStatus.BLOCKED));
        Table<?> settled = this.campaignStatusSubquery(campaignId, SETTLED, List.of(ExecutionStatus.SETTLED));
        Table<?> running = this.campaignStatusSubquery(campaignId, RUNNING, List.of(ExecutionStatus.RUNNING));
        Table<?> ready = this.campaignStatusSubquery(campaignId, READY, List.of(ExecutionStatus.READY));
        Resource rs = Tables.RESOURCE.as("rs");
        SelectSeekStep1 query = this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as(REQUIREMENT_ID), (SelectField)rs.field(NAME).as(REQUIREMENT_NAME), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as(REQUIREMENT_REF), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as(REQUIREMENT_VERSION_NUMBER), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY.as(CRITICALITY), (SelectField)DSL.coalesce((Field)success.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.SUCCESS.name()), (SelectField)DSL.coalesce((Field)failure.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.FAILURE.name()), (SelectField)DSL.coalesce((Field)untestable.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.UNTESTABLE.name()), (SelectField)DSL.coalesce((Field)blocked.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.BLOCKED.name()), (SelectField)DSL.coalesce((Field)running.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.RUNNING.name()), (SelectField)DSL.coalesce((Field)ready.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.READY.name()), (SelectField)DSL.coalesce((Field)settled.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.SETTLED.name())).from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)rs).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq(rs.field(RES_ID, Long.class))).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID.eq(rs.field(RES_ID, Long.class))).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).leftJoin(success).on(success.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(failure).on(failure.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(untestable).on(untestable.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(blocked).on(blocked.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(settled).on(settled.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(running).on(running.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(ready).on(ready.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).orderBy((OrderField)rs.field(NAME));
        return query.fetchInto(QuaCoverageRequirementBean.class);
    }

    public Table<?> campaignStatusSubquery(Long campaignId, String alias, List<ExecutionStatus> execStatuses) {
        List<String> statuses = execStatuses.stream().map(Enum::toString).toList();
        Condition statusCondition = Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(statuses);
        return this.dsl.selectDistinct((SelectField)DSL.count().as(COUNTS), (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.as(ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(statusCondition.and(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId))).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID}).asTable(alias);
    }

    public List<QuaCoverageIterationBean> getIterationsByCampaign(Long campaignId) {
        return this.dsl.selectDistinct((SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ID, (SelectField)Tables.ITERATION.NAME.as("iterationName"), (SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER).from((TableLike)Tables.CAMPAIGN_ITERATION).leftJoin((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).orderBy((OrderField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER).fetchInto(QuaCoverageIterationBean.class);
    }

    public List<QuaCoverageRequirementBean> getRequirementsByIteration(Long iterationId) {
        Table<?> success = this.iterationStatusSubquery(iterationId, SUCCESS, List.of(ExecutionStatus.SUCCESS, ExecutionStatus.WARNING));
        Table<?> failure = this.iterationStatusSubquery(iterationId, FAILURE, List.of(ExecutionStatus.FAILURE));
        Table<?> untestable = this.iterationStatusSubquery(iterationId, UNTESTABLE, List.of(ExecutionStatus.UNTESTABLE));
        Table<?> blocked = this.iterationStatusSubquery(iterationId, BLOCKED, List.of(ExecutionStatus.BLOCKED));
        Table<?> settled = this.iterationStatusSubquery(iterationId, SETTLED, List.of(ExecutionStatus.SETTLED));
        Table<?> running = this.iterationStatusSubquery(iterationId, RUNNING, List.of(ExecutionStatus.RUNNING));
        Table<?> ready = this.iterationStatusSubquery(iterationId, READY, List.of(ExecutionStatus.READY));
        Resource rs = Tables.RESOURCE.as("rs");
        SelectSeekStep1 query = this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as(REQUIREMENT_ID), (SelectField)rs.field(NAME).as(REQUIREMENT_NAME), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as(REQUIREMENT_REF), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as(REQUIREMENT_VERSION_NUMBER), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY.as(CRITICALITY), (SelectField)DSL.coalesce((Field)success.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.SUCCESS.name()), (SelectField)DSL.coalesce((Field)failure.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.FAILURE.name()), (SelectField)DSL.coalesce((Field)untestable.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.UNTESTABLE.name()), (SelectField)DSL.coalesce((Field)blocked.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.BLOCKED.name()), (SelectField)DSL.coalesce((Field)running.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.RUNNING.name()), (SelectField)DSL.coalesce((Field)ready.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.READY.name()), (SelectField)DSL.coalesce((Field)settled.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.SETTLED.name())).from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)rs).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(rs.field(RES_ID, Long.class))).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq(rs.field(RES_ID, Long.class))).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin(success).on(success.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(failure).on(failure.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(untestable).on(untestable.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(blocked).on(blocked.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(settled).on(settled.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(running).on(running.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(ready).on(ready.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId)).orderBy((OrderField)rs.field(NAME));
        return query.fetchInto(QuaCoverageRequirementBean.class);
    }

    public Table<?> iterationStatusSubquery(Long iterationId, String alias, List<ExecutionStatus> execStatuses) {
        List<String> statuses = execStatuses.stream().map(Enum::toString).toList();
        Condition statusCondition = Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(statuses);
        return this.dsl.selectDistinct((SelectField)DSL.count().as(COUNTS), (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.as(ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(statusCondition.and(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId))).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID}).asTable(alias);
    }

    public List<QuaCoverageProjectBean> getProject(Long projectId) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("projectName")).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.PROJECT.PROJECT_TYPE.eq((Object)PROJECT_TYPE)).fetchInto(QuaCoverageProjectBean.class);
    }

    public List<String> getDisabledExecutionStatus(Long projectId) {
        return this.dsl.select((SelectField)Tables.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS).from((TableLike)Tables.DISABLED_EXECUTION_STATUS).where(Tables.DISABLED_EXECUTION_STATUS.CL_ID.eq((Object)projectId)).fetch((Field)Tables.DISABLED_EXECUTION_STATUS.EXECUTION_STATUS);
    }

    public List<Long> getProjectIds(Collection<Integer> milestoneIds) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).leftJoin((TableLike)Tables.MILESTONE_BINDING).on(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_BINDING.MILESTONE_ID)).where(Tables.PROJECT.PROJECT_TYPE.eq((Object)PROJECT_TYPE)).and(Tables.MILESTONE.MILESTONE_ID.in(milestoneIds)).fetch().getValues((Field)Tables.PROJECT.PROJECT_ID);
    }

    public String getMilestoneLabel(Integer milestoneId) {
        return (String)this.dsl.select((SelectField)Tables.MILESTONE.LABEL).from((TableLike)Tables.MILESTONE).where(Tables.MILESTONE.MILESTONE_ID.eq((Object)milestoneId)).fetchOne((Field)Tables.MILESTONE.LABEL);
    }

    public List<QuaCoverageTestSuiteBean> getTestSuites(Long iterationId) {
        return this.dsl.selectDistinct((SelectField)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID, (SelectField)Tables.TEST_SUITE.NAME.as("testSuiteName"), (SelectField)Tables.ITERATION_TEST_SUITE.ITERATION_ID).from((TableLike)Tables.ITERATION_TEST_SUITE).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).where(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Object)iterationId)).fetchInto(QuaCoverageTestSuiteBean.class);
    }

    public List<QuaCoverageRequirementBean> getRequirementsByTestSuite(Long testSuiteId) {
        Table<?> success = this.testSuiteStatusSubquery(testSuiteId, SUCCESS, List.of(ExecutionStatus.SUCCESS, ExecutionStatus.WARNING));
        Table<?> failure = this.testSuiteStatusSubquery(testSuiteId, FAILURE, List.of(ExecutionStatus.FAILURE));
        Table<?> untestable = this.testSuiteStatusSubquery(testSuiteId, UNTESTABLE, List.of(ExecutionStatus.UNTESTABLE));
        Table<?> blocked = this.testSuiteStatusSubquery(testSuiteId, BLOCKED, List.of(ExecutionStatus.BLOCKED));
        Table<?> settled = this.testSuiteStatusSubquery(testSuiteId, SETTLED, List.of(ExecutionStatus.SETTLED));
        Table<?> running = this.testSuiteStatusSubquery(testSuiteId, RUNNING, List.of(ExecutionStatus.RUNNING));
        Table<?> ready = this.testSuiteStatusSubquery(testSuiteId, READY, List.of(ExecutionStatus.READY));
        Resource rs = Tables.RESOURCE.as("rs");
        SelectSeekStep1 query = this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as(REQUIREMENT_ID), (SelectField)rs.field(NAME).as(REQUIREMENT_NAME), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as(REQUIREMENT_REF), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as(REQUIREMENT_VERSION_NUMBER), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY.as(CRITICALITY), (SelectField)DSL.coalesce((Field)success.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.SUCCESS.name()), (SelectField)DSL.coalesce((Field)failure.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.FAILURE.name()), (SelectField)DSL.coalesce((Field)untestable.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.UNTESTABLE.name()), (SelectField)DSL.coalesce((Field)blocked.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.BLOCKED.name()), (SelectField)DSL.coalesce((Field)running.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.RUNNING.name()), (SelectField)DSL.coalesce((Field)ready.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.READY.name()), (SelectField)DSL.coalesce((Field)settled.field(COUNTS, Integer.class), (Object)0).as(ExecutionStatus.SETTLED.name())).from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)rs).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(rs.field(RES_ID, Long.class))).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq(rs.field(RES_ID, Long.class))).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin(success).on(success.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(failure).on(failure.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(untestable).on(untestable.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(blocked).on(blocked.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(settled).on(settled.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(running).on(running.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).leftJoin(ready).on(ready.field(ID, Integer.class).eq(rs.field(RES_ID, Integer.class))).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)testSuiteId)).orderBy((OrderField)rs.field(NAME));
        return query.fetchInto(QuaCoverageRequirementBean.class);
    }

    public Table<?> testSuiteStatusSubquery(Long testSuiteId, String alias, List<ExecutionStatus> execStatuses) {
        List<String> statuses = execStatuses.stream().map(Enum::toString).toList();
        Condition statusCondition = Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in(statuses);
        return this.dsl.selectDistinct((SelectField)DSL.count().as(COUNTS), (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.as(ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(statusCondition.and(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)testSuiteId))).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID}).asTable(alias);
    }
}

