/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.beans;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.squashtest.tm.plugin.report.books.requirements.beans.I18nHelper;
import org.squashtest.tm.plugin.report.books.requirements.beans.TextFormatter;

public class Cuf {
    private Long boundEntityId;
    private String type;
    private String label;
    private String value;
    private String inputType;

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = this.computeValue(value);
    }

    private String computeValue(String value) {
        if ("CHECKBOX".equals(this.inputType)) {
            if (Boolean.TRUE.toString().equals(value)) {
                return I18nHelper.translate("label.true");
            }
            return I18nHelper.translate("label.false");
        }
        if ("DATE_PICKER".equals(this.inputType)) {
            return this.formatDate(value);
        }
        if ("TAG".equals(this.type)) {
            return TextFormatter.formatTagCuf(value);
        }
        return value;
    }

    private String formatDate(String date) {
        LocalDate localDate = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(I18nHelper.translate("report.books.requirements.cuf.dateFormat"));
        return localDate.format(formatter);
    }

    public boolean isRichText() {
        return "RTF".equals(this.type);
    }

    public Long getBoundEntityId() {
        return this.boundEntityId;
    }

    public void setBoundEntityId(Long boundEntityId) {
        this.boundEntityId = boundEntityId;
    }
}

