/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.util;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.squashtest.tm.api.utils.AttachmentImageHelper;

public class Converter {
    private static final int MAX_IMAGE_SIZE = 700;
    private static final String END_TEXT_SEPARATOR = "=Sep=";
    private final AttachmentImageHelper attachmentImageHelper;
    private Object object;

    public Converter(AttachmentImageHelper attachmentImageHelper) {
        this.attachmentImageHelper = attachmentImageHelper;
    }

    public Converter from(Object toConvert) {
        this.object = toConvert;
        return this;
    }

    public String toString() {
        if (this.object == null) {
            return "";
        }
        return this.object.toString();
    }

    public String toRichText(List<String> html) {
        if (this.object == null) {
            return "";
        }
        String richText = this.object.toString();
        if (richText.contains("img")) {
            richText = this.findAndReplaceImageHeightWidthValue(richText);
        }
        if (richText.contains("/attachments/download/")) {
            Pattern pattern = Pattern.compile("<img.*?src=([\"'])?(?<src>(?:(?!\\2)[^\"'])+attachments\\/download\\/(?<id>\\d+)([^\"'])?).*?>");
            Matcher matcher = pattern.matcher(richText);
            while (matcher.find()) {
                String src = matcher.group("src");
                String id = matcher.group("id");
                String str = this.attachmentImageHelper.getImageBase64String(Long.valueOf(Long.parseLong(id)));
                if (str.isBlank()) continue;
                richText = richText.replace(src, "data:image/png;base64," + str);
            }
        }
        StringBuilder sb = new StringBuilder(richText);
        sb.insert(0, "<html><meta charset='UTF-8'>");
        sb.append("</html>");
        String newVal = "<w:altChunk r:id='reportRichText" + html.size() + "' />";
        html.add(sb.toString());
        return newVal;
    }

    private String findAndReplaceImageHeightWidthValue(String string) {
        String regexPattern = "(?<=\")([0-9]+)(?=\")";
        Pattern pattern = Pattern.compile(regexPattern);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String stringAttribute = matcher.group();
            int intAttribute = Integer.parseInt(stringAttribute);
            intAttribute = Math.min(intAttribute, 700);
            string = string.replace(stringAttribute, Integer.toString(intAttribute));
        }
        return string;
    }

    public Long toLong() {
        if (this.object == null) {
            return null;
        }
        Class<?> clazz = this.object.getClass();
        long result = clazz.equals(String.class) ? Long.parseLong((String)this.object) : (clazz.equals(BigInteger.class) ? ((BigInteger)this.object).longValue() : (clazz.equals(Long.class) ? (Long)this.object : (clazz.equals(Integer.class) ? ((Integer)this.object).longValue() : (clazz.equals(Timestamp.class) ? ((Timestamp)this.object).getTime() : (clazz.equals(Date.class) ? ((Date)this.object).getTime() : Long.parseLong(this.object.toString()))))));
        return result;
    }

    public Boolean toBoolean() {
        if (this.object == null) {
            return false;
        }
        Class<?> clazz = this.object.getClass();
        Boolean result = null;
        if (clazz.equals(String.class)) {
            result = Boolean.valueOf((String)this.object);
        } else if (clazz.equals(Boolean.class)) {
            result = (Boolean)this.object;
        }
        return result;
    }

    public Date toDate() {
        if (this.object instanceof Date) {
            return (Date)this.object;
        }
        return new Date(0L);
    }

    public Collection<Long> fromStringToIdList(String strIds) {
        String strIdsWithoutSeparator = strIds.replace(END_TEXT_SEPARATOR, "");
        HashSet<Long> previousIdList = new HashSet<Long>();
        String[] stringArray = strIdsWithoutSeparator.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String strId = stringArray[n2];
            previousIdList.add(this.from(strId).toLong());
            ++n2;
        }
        return previousIdList;
    }
}

