/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.query;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSeekStep1;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.jooq.domain.tables.RequirementFolder;
import org.squashtest.tm.jooq.domain.tables.RequirementLibraryNode;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.jooq.domain.tables.Resource;
import org.squashtest.tm.jooq.domain.tables.RlnRelationshipClosure;
import org.squashtest.tm.plugin.report.books.requirements.beans.AttachReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.Cuf;
import org.squashtest.tm.plugin.report.books.requirements.beans.LowReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.Project;
import org.squashtest.tm.plugin.report.books.requirements.beans.ReqLink;
import org.squashtest.tm.plugin.report.books.requirements.beans.RequirementLastVersion;
import org.squashtest.tm.plugin.report.books.requirements.beans.TestCase;

@Service(value="squashtest.tm.plugin.report.books.requirements.query.TestCasesTreeQueryFinder")
public class RequirementTreeQueryFinder {
    private static final Requirement REQUIREMENT1 = Tables.REQUIREMENT.as("REQUIREMENT");
    private static final Requirement LINKED_REQUIREMENT = Tables.REQUIREMENT.as("LINKED_REQUIREMENT");
    private static final String VERSION_IDS = "versionIds";
    public static final String REQ_ID = "REQ_ID";
    public static final String IS_PARENT = "IS_PARENT";
    public static final String TC_ID = "TC_ID";
    public static final String TC_REF = "TC_REF";
    public static final String TC_NAME = "TC_NAME";
    public static final String TC_MILESTONE = "TC_MILESTONE";
    public static final String TC_STATUS = "TC_STATUS";
    public static final String TC_IMPORTANCE = "TC_IMPORTANCE";
    public static final String NUMBER_OF_VERSIONS = "NUMBER_OF_VERSIONS";
    public static final String HIGH_LEVEL_REQ_LABEL = "HIGH_LEVEL_REQ_LABEL";
    public static final String P = "P";
    public static final String MODIFY_BY = "MODIFY_BY";
    public static final String MODIFY_ON = "MODIFY_ON";
    public static final String LINKREQ_ID = "LINKREQ_ID";
    public static final String LINKREQ_REF = "LINKREQ_REF";
    public static final String LINKREQ_NAME = "LINKREQ_NAME";
    private final DSLContext dsl;

    @Inject
    public RequirementTreeQueryFinder(DSLContext dsl) {
        this.dsl = dsl;
    }

    List<Long> findIdsByProject(List<Long> projectIds) {
        if (CollectionUtils.isEmpty(projectIds)) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.in(projectIds)).fetch((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Long.class);
    }

    public List<Project> findProjects(List<Long> projectIds) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME")).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.in(projectIds)).and(Tables.PROJECT.PROJECT_TYPE.eq((Object)P)).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.PROJECT.NAME}).orderBy((OrderField)Tables.PROJECT.NAME).fetchInto(Project.class);
    }

    List<Long> findIdsBySelection(List<Long> ids, List<Long> projectIds) {
        if (Objects.isNull(ids) || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(ids)).and(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.in(projectIds)).fetch((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Long.class);
    }

    public List<Project> findProjectsBySelection(List<Long> ids) {
        if (Objects.isNull(ids) || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME")).from((TableLike)Tables.PROJECT).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.in(ids)).and(Tables.PROJECT.PROJECT_TYPE.eq((Object)P)).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.PROJECT.NAME}).orderBy((OrderField)Tables.PROJECT.NAME.asc()).fetchInto(Project.class);
    }

    List<Long> findIdsByMilestone(List<String> milestoneIds, List<Long> projectIds) {
        if (milestoneIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.in(milestoneIds)).and(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.in(projectIds)).fetch((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Long.class);
    }

    public List<Project> findProjectsByMilestone(List<Long> milestoneIds, List<Long> projectIds) {
        if (milestoneIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME")).from((TableLike)Tables.PROJECT).join((TableLike)Tables.MILESTONE_BINDING).on(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.MILESTONE_BINDING.MILESTONE_ID.in(milestoneIds)).and(Tables.PROJECT.PROJECT_TYPE.eq((Object)P)).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID}).orderBy((OrderField)Tables.PROJECT.NAME).fetchInto(Project.class);
    }

    public List<Long> findIdsByTags(List<String> tags, List<Long> projectIds) {
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID).from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)"REQUIREMENT_VERSION")).and(Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL.in(tags)).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"TAG")).and(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.in(projectIds)).fetch((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Long.class);
    }

    public List<Project> findProjectsByTags(List<String> tags, List<Long> projectIds) {
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME")).from((TableLike)Tables.PROJECT).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID)).join((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.CUSTOM_FIELD_VALUE.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID)).join((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL.in(tags)).and(Tables.PROJECT.PROJECT_TYPE.eq((Object)P)).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID}).orderBy((OrderField)Tables.PROJECT.NAME).fetchInto(Project.class);
    }

    List<RequirementLastVersion> getReqDataForRlnIds(List<Long> requirementIds, String requirementsSortOrder) {
        RlnRelationshipClosure clos = Tables.RLN_RELATIONSHIP_CLOSURE.as("clos");
        RequirementLibraryNode ancestorRln = Tables.REQUIREMENT_LIBRARY_NODE.as("ancestorRln");
        Requirement ancestorR = Tables.REQUIREMENT.as("ancestorR");
        RequirementFolder ancestorFolder = Tables.REQUIREMENT_FOLDER.as("ancestorFolder");
        Resource ancestorResource = Tables.RESOURCE.as("ancestorResource");
        RequirementVersion ancestorRv = Tables.REQUIREMENT_VERSION.as("ancestorRv");
        RequirementLibraryNode descendantRln = Tables.REQUIREMENT_LIBRARY_NODE.as("descendantRln");
        Requirement descendantR = Tables.REQUIREMENT.as("descendantR");
        RequirementVersion descendantRv = Tables.REQUIREMENT_VERSION.as("descendantRv");
        RequirementFolder descendantFolder = Tables.REQUIREMENT_FOLDER.as("descendantFolder");
        Resource descendantResource = Tables.RESOURCE.as("descendantResource");
        Requirement hlrReq = Tables.REQUIREMENT.as("hlrReq");
        RequirementVersion hlrRv = Tables.REQUIREMENT_VERSION.as("hlrRv");
        Resource hrlResource = Tables.RESOURCE.as("hrlResource");
        Field orderKey = DSL.when((Condition)DSL.val((String)requirementsSortOrder).eq((Object)"POSITIONAL"), (Field)DSL.concat((Field[])new Field[]{DSL.lpad((Field)Tables.PROJECT.RL_ID.cast(String.class), (int)5, (char)'0'), DSL.inline((String)"-"), DSL.groupConcat((Field)DSL.coalesce((Field)DSL.lpad((Field)Tables.RLN_RELATIONSHIP.CONTENT_ORDER.cast(String.class), (int)5, (char)'0'), (Field[])new Field[]{DSL.lpad((Field)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ORDER.cast(String.class), (int)5, (char)'0')})).orderBy(new OrderField[]{clos.DEPTH.desc()})})).otherwise(DSL.replace((Field)DSL.groupConcat((Field)DSL.concat((Field[])new Field[]{DSL.coalesce((Field)ancestorRv.REFERENCE, (Field[])new Field[]{DSL.inline((String)"")}), ancestorResource.NAME})).orderBy(new OrderField[]{clos.DEPTH.desc()}), (String)" ", (String)"")).as("order_key");
        SelectSeekStep1 query = this.dsl.select(new SelectFieldOrAsterisk[]{descendantRln.RLN_ID.as(REQ_ID), DSL.when((Condition)descendantFolder.RES_ID.isNotNull(), (Field)DSL.inline((boolean)true)).otherwise((Field)DSL.inline((boolean)false)).as("IS_FOLDER"), DSL.when((Condition)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (Field)DSL.inline((boolean)true)).otherwise((Field)DSL.inline((boolean)false)).as("IS_HLR"), DSL.max((Field)clos.DEPTH).as("LEVEL"), DSL.groupConcat((Field)DSL.concat((Field[])new Field[]{DSL.coalesce((Field)ancestorRv.REFERENCE, (Object)""), ancestorResource.NAME})).orderBy(new OrderField[]{clos.DEPTH.desc()}).as("PATH"), Tables.PROJECT.PROJECT_ID, Tables.PROJECT.NAME.as("PROJECT_NAME"), descendantRv.VERSION_NUMBER.as(NUMBER_OF_VERSIONS), DSL.max((Field)DSL.when((Condition)hlrRv.REFERENCE.eq((Object)""), (Field)hrlResource.NAME).otherwise(DSL.concat((Field[])new Field[]{hlrRv.REFERENCE, DSL.inline((String)" - "), hrlResource.NAME}))).as(HIGH_LEVEL_REQ_LABEL), descendantRv.RES_ID.as("VERSION_ID"), descendantRv.REFERENCE, descendantResource.NAME, descendantRv.VERSION_NUMBER, DSL.coalesce((Field)descendantRv.REQUIREMENT_STATUS, (Field[])new Field[]{DSL.inline((String)"WORK_IN_PROGRESS")}).as("STATUS"), DSL.coalesce((Field)descendantRv.CRITICALITY, (Field[])new Field[]{DSL.inline((String)"UNDEFINED")}).as("CRITICALITY"), DSL.coalesce((Field)Tables.INFO_LIST_ITEM.LABEL, (Field[])new Field[]{DSL.inline((String)"UNDEFINED")}).as("CATEGORY"), DSL.coalesce((Field)Tables.INFO_LIST_ITEM.ITEM_TYPE, (Field[])new Field[]{DSL.inline((String)"UNDEFINED")}).as("CATEGORY_TYPE"), descendantResource.CREATED_BY, descendantResource.CREATED_ON, descendantResource.LAST_MODIFIED_BY.as("MODIFIED_BY"), descendantResource.LAST_MODIFIED_ON.as("MODIFIED_ON"), DSL.groupConcatDistinct((Field)DSL.when((Condition)Tables.MILESTONE.LABEL.isNotNull(), (Field)DSL.concat((Field[])new Field[]{Tables.MILESTONE.LABEL, DSL.inline((String)"=Sep=")}))).as("MILESTONES"), DSL.countDistinct((Field)Tables.ATTACHMENT.ATTACHMENT_ID).as("ATTACHMENTS"), descendantResource.DESCRIPTION, orderKey}).from((TableLike)clos).leftJoin((TableLike)ancestorRln).on(clos.ANCESTOR_ID.eq((Field)ancestorRln.RLN_ID)).leftJoin((TableLike)ancestorR).on(ancestorR.RLN_ID.eq((Field)ancestorRln.RLN_ID)).leftJoin((TableLike)ancestorFolder).on(ancestorFolder.RLN_ID.eq((Field)ancestorRln.RLN_ID)).leftJoin((TableLike)ancestorResource).on(ancestorResource.RES_ID.eq((Field)ancestorR.CURRENT_VERSION_ID).or(ancestorResource.RES_ID.eq((Field)ancestorFolder.RES_ID))).leftJoin((TableLike)ancestorRv).on(ancestorRv.RES_ID.eq((Field)ancestorResource.RES_ID)).innerJoin((TableLike)descendantRln).on(clos.DESCENDANT_ID.eq((Field)descendantRln.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_LIBRARY_CONTENT).on(clos.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID)).leftJoin((TableLike)descendantR).on(descendantRln.RLN_ID.eq((Field)descendantR.RLN_ID)).leftJoin((TableLike)descendantRv).on(descendantRv.RES_ID.eq((Field)descendantR.CURRENT_VERSION_ID)).leftJoin((TableLike)descendantFolder).on(descendantFolder.RLN_ID.eq((Field)descendantRln.RLN_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)descendantRln.RLN_ID)).leftJoin((TableLike)descendantResource).on(descendantResource.RES_ID.eq((Field)descendantRv.RES_ID).or(descendantResource.RES_ID.eq((Field)descendantFolder.RES_ID))).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(ancestorResource.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)Tables.ATTACHMENT).on(ancestorResource.ATTACHMENT_LIST_ID.eq((Field)Tables.ATTACHMENT.ATTACHMENT_LIST_ID)).leftJoin((TableLike)Tables.PROJECT).on(descendantRln.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.INFO_LIST_ITEM).on(descendantRv.CATEGORY.eq((Field)Tables.INFO_LIST_ITEM.ITEM_ID)).leftJoin((TableLike)hlrReq).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)hlrReq.RLN_ID)).leftJoin((TableLike)hlrRv).on(hlrRv.REQUIREMENT_ID.eq((Field)descendantR.HIGH_LEVEL_REQUIREMENT_ID).and(hlrReq.CURRENT_VERSION_ID.eq((Field)hlrRv.RES_ID))).leftJoin((TableLike)hrlResource).on(hrlResource.RES_ID.eq((Field)hlrRv.RES_ID)).leftJoin((TableLike)Tables.RLN_RELATIONSHIP).on(clos.ANCESTOR_ID.eq((Field)Tables.RLN_RELATIONSHIP.DESCENDANT_ID)).where(clos.DESCENDANT_ID.in((Select)this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(requirementIds))).or(clos.DESCENDANT_ID.in((Select)this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(requirementIds))))).groupBy(new GroupField[]{clos.DESCENDANT_ID, descendantRln.RLN_ID, descendantFolder.RES_ID, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID, Tables.PROJECT.PROJECT_ID, descendantRv.RES_ID, descendantResource.RES_ID, Tables.INFO_LIST_ITEM.ITEM_ID}).orderBy((OrderField)DSL.field((String)"order_key"));
        return query.fetchInto(RequirementLastVersion.class);
    }

    List<String> getVersionIds(List<Long> requirementIds) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID, (SelectField)DSL.groupConcat((Field)Tables.REQUIREMENT_VERSION.RES_ID).separator("=Sep=").as(VERSION_IDS)).from((TableLike)Tables.REQUIREMENT_VERSION).leftJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT.RLN_ID.in(requirementIds)).and(Tables.REQUIREMENT_VERSION.RES_ID.notEqual((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT.RLN_ID}).fetch(VERSION_IDS, String.class);
    }

    List<org.squashtest.tm.plugin.report.books.requirements.beans.RequirementVersion> getPreviousVersionsData(Collection<Long> previousVersionIds) {
        return this.dsl.select((SelectField)Tables.RESOURCE.RES_ID.as("VERSION_ID"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as("REFERENCE"), (SelectField)Tables.RESOURCE.NAME.as("NAME"), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as("VERSION_NUMBER"), (SelectField)DSL.coalesce((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS, (Field[])new Field[]{DSL.inline((String)RequirementStatus.WORK_IN_PROGRESS.toString())}).as("STATUS"), (SelectField)DSL.coalesce((Field)Tables.REQUIREMENT_VERSION.CRITICALITY, (Field[])new Field[]{DSL.inline((String)"UNDEFINED")}).as("CRITICALITY"), (SelectField)DSL.coalesce((Field)Tables.INFO_LIST_ITEM.LABEL, (Field[])new Field[]{DSL.inline((String)"UNDEFINED")}).as("CATEGORY"), (SelectField)DSL.coalesce((Field)Tables.INFO_LIST_ITEM.ITEM_TYPE, (Field[])new Field[]{DSL.inline((String)"UNDEFINED")}).as("CATEGORY_TYPE"), (SelectField)Tables.RESOURCE.CREATED_BY.as("CREATED_BY"), (SelectField)Tables.RESOURCE.CREATED_ON.as("CREATED_ON"), (SelectField)Tables.RESOURCE.LAST_MODIFIED_BY.as(MODIFY_BY), (SelectField)Tables.RESOURCE.LAST_MODIFIED_ON.as(MODIFY_ON), (SelectField)DSL.groupConcat((Field)DSL.when((Condition)Tables.MILESTONE.LABEL.isNotNull(), (Field)DSL.concat((Field)Tables.MILESTONE.LABEL, (String)"=Sep=")).otherwise(null)).separator("=Sep=").as("MILESTONES"), (SelectField)DSL.count((Field)Tables.ATTACHMENT.ATTACHMENT_ID).as("ATTACHMENTS"), (SelectField)Tables.RESOURCE.DESCRIPTION.as("DESCRIPTION"), (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as(REQ_ID)).from((TableLike)Tables.RESOURCE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)Tables.ATTACHMENT).on(Tables.RESOURCE.ATTACHMENT_LIST_ID.eq((Field)Tables.ATTACHMENT.ATTACHMENT_LIST_ID)).leftJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.REQUIREMENT_VERSION.CATEGORY.eq((Field)Tables.INFO_LIST_ITEM.ITEM_ID)).where(Tables.RESOURCE.RES_ID.in(previousVersionIds)).groupBy(new GroupField[]{Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_VERSION.RES_ID, Tables.REQUIREMENT.MODE, Tables.INFO_LIST_ITEM.LABEL, Tables.INFO_LIST_ITEM.ITEM_TYPE}).fetchInto(org.squashtest.tm.plugin.report.books.requirements.beans.RequirementVersion.class);
    }

    List<TestCase> getTestCasesDataForVersionIds(List<Long> requirementIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as(TC_ID), (SelectField)Tables.REQUIREMENT_VERSION.RES_ID.as(REQ_ID), (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE.REFERENCE.as(TC_REF), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as(TC_NAME), (SelectField)DSL.groupConcat((Field)DSL.when((Condition)Tables.MILESTONE.LABEL.isNotNull(), (Field)DSL.concat((Field)Tables.MILESTONE.LABEL, (String)"=Sep=")).otherwise(null)).separator("=Sep=").as(TC_MILESTONE), (SelectField)Tables.TEST_CASE.TC_STATUS.as(TC_STATUS), (SelectField)Tables.TEST_CASE.IMPORTANCE.as(TC_IMPORTANCE)).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementIds)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.REQUIREMENT_VERSION.RES_ID, Tables.PROJECT.NAME, Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE.IMPORTANCE, Tables.TEST_CASE.TCLN_ID}).orderBy((OrderField)Tables.REQUIREMENT_VERSION.RES_ID).fetchInto(TestCase.class);
    }

    List<TestCase> getTestCasesDataForHLR(List<Long> nodeIds) {
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as(TC_ID), (SelectField)RequirementTreeQueryFinder.LINKED_REQUIREMENT.RLN_ID.as(REQ_ID), (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE.REFERENCE.as("REFERENCE").as(TC_REF), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("TEST_CASE_NAME").as(TC_NAME), (SelectField)DSL.groupConcat((Field)DSL.when((Condition)Tables.MILESTONE.LABEL.isNotNull(), (Field)DSL.concat((Field)Tables.MILESTONE.LABEL, (String)"=Sep=")).otherwise(null)).separator("=Sep=").as(TC_MILESTONE), (SelectField)Tables.TEST_CASE.TC_STATUS.as(TC_STATUS), (SelectField)Tables.TEST_CASE.IMPORTANCE.as(TC_IMPORTANCE), (SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).join((TableLike)REQUIREMENT1).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)RequirementTreeQueryFinder.REQUIREMENT1.CURRENT_VERSION_ID)).leftJoin((TableLike)LINKED_REQUIREMENT).on(RequirementTreeQueryFinder.REQUIREMENT1.HIGH_LEVEL_REQUIREMENT_ID.eq((Field)RequirementTreeQueryFinder.LINKED_REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(RequirementTreeQueryFinder.REQUIREMENT1.HIGH_LEVEL_REQUIREMENT_ID.in(nodeIds)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, RequirementTreeQueryFinder.LINKED_REQUIREMENT.RLN_ID, Tables.REQUIREMENT_VERSION.RES_ID, Tables.PROJECT.NAME, Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE.IMPORTANCE, Tables.TEST_CASE.TCLN_ID}).fetchInto(TestCase.class);
    }

    List<Cuf> getCufsDataForVersionIds(List<Long> versionIds) {
        return this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID, (SelectField)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.as("TYPE"), (SelectField)Tables.CUSTOM_FIELD.LABEL, (SelectField)DSL.when((Condition)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.ne((Object)"RTF"), (Field)Tables.CUSTOM_FIELD_VALUE.VALUE).otherwise((Field)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE).as("VALUE"), (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE).from((TableLike)Tables.CUSTOM_FIELD_VALUE).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD_VALUE.CF_ID.eq((Field)Tables.CUSTOM_FIELD.CF_ID)).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFB_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(versionIds)).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.in((Object[])new String[]{"REQUIREMENT_FOLDER", "REQUIREMENT_VERSION"})).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.ne((Object)"TAG")).groupBy(new GroupField[]{Tables.CUSTOM_FIELD_VALUE.CFV_ID, Tables.CUSTOM_FIELD.LABEL, Tables.CUSTOM_FIELD.INPUT_TYPE, Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE, Tables.CUSTOM_FIELD_BINDING.POSITION, Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID}).orderBy((OrderField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID, (OrderField)Tables.CUSTOM_FIELD_BINDING.POSITION).fetchInto(Cuf.class);
    }

    List<AttachReq> getAttachReqForReqIds(List<Long> requirementIds) {
        RlnRelationshipClosure rlnRC = Tables.RLN_RELATIONSHIP_CLOSURE.as("RLN_RC");
        SelectHavingStep part1 = this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.as(REQ_ID), (SelectField)rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).as(LINKREQ_ID), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.RESOURCE.NAME, (SelectField)DSL.groupConcat((Field)DSL.when((Condition)Tables.MILESTONE.LABEL.isNotNull(), (Field)DSL.concat((Field[])new Field[]{Tables.MILESTONE.LABEL, DSL.inline((String)"=Sep=")}))).as("MILESTONES"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)DSL.inline((boolean)true).as(IS_PARENT), (SelectField)DSL.max((Field)rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH)).as("DEPTH")).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).join((TableLike)rlnRC).on(rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).and(rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).ne((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).leftJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq(rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID))).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT.CURRENT_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(requirementIds)).and(Tables.REQUIREMENT_VERSION.RES_ID.isNotNull()).and(Tables.REQUIREMENT_FOLDER.RES_ID.isNull()).groupBy(new GroupField[]{rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID), Tables.REQUIREMENT_VERSION.RES_ID, Tables.RESOURCE.RES_ID, Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)});
        SelectHavingStep part2 = this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.as(REQ_ID), (SelectField)rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).as(LINKREQ_ID), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as(LINKREQ_REF), (SelectField)Tables.RESOURCE.NAME.as(LINKREQ_NAME), (SelectField)DSL.groupConcat((Field)DSL.when((Condition)Tables.MILESTONE.LABEL.isNotNull(), (Field)DSL.concat((Field[])new Field[]{Tables.MILESTONE.LABEL, DSL.inline((String)"=Sep=")}))).as("MILESTONES"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)DSL.inline((boolean)false).as(IS_PARENT), (SelectField)DSL.max((Field)rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH)).as("DEPTH")).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).join((TableLike)rlnRC).on(rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).and(rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).ne((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).leftJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq(rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT.CURRENT_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(requirementIds)).and(Tables.REQUIREMENT_VERSION.RES_ID.isNotNull()).and(Tables.REQUIREMENT_FOLDER.RES_ID.isNull()).groupBy(new GroupField[]{rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID), Tables.REQUIREMENT_VERSION.RES_ID, Tables.RESOURCE.RES_ID, Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, rlnRC.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)});
        return this.dsl.selectFrom((TableLike)part1.union((Select)part2).asTable("unioned")).orderBy((OrderField)DSL.field((String)REQ_ID, Long.class), (OrderField)DSL.field((String)IS_PARENT, Short.class).desc(), (OrderField)DSL.field((String)"DEPTH", Short.class)).fetchInto(AttachReq.class);
    }

    public List<Cuf> getTagCufsDataForVersionIds(List<Long> versionIds) {
        return this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.as("VERSION_ID"), (SelectField)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.as("TYPE"), (SelectField)Tables.CUSTOM_FIELD.LABEL.as("LABEL"), (SelectField)DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).separator("=Sep=").as("VALUE"), (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE.as("INPUT_TYPE")).from((TableLike)Tables.CUSTOM_FIELD_VALUE).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_VALUE.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).join((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.in((Object[])new String[]{"REQUIREMENT_FOLDER", "REQUIREMENT_VERSION"})).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(versionIds)).groupBy(new GroupField[]{Tables.CUSTOM_FIELD_VALUE.CFV_ID, Tables.CUSTOM_FIELD.CF_ID, Tables.CUSTOM_FIELD_BINDING.POSITION}).orderBy((OrderField)Tables.CUSTOM_FIELD_BINDING.POSITION).fetchInto(Cuf.class);
    }

    public List<ReqLink> getReqLinkDataQueryForVersionIds(List<Long> versionIds) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID.as(REQ_ID), (SelectField)Tables.REQUIREMENT_VERSION_LINK.LINK_DIRECTION, (SelectField)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_1.as("role1"), (SelectField)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2.as("role2"), (SelectField)Tables.PROJECT.NAME.as("PROJECT"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER, (SelectField)DSL.groupConcat((Field)DSL.when((Condition)Tables.MILESTONE.LABEL.isNotNull(), (Field)Tables.MILESTONE.LABEL.concat(new String[]{"=Sep="})).otherwise(null)).as("MILESTONES")).from((TableLike)Tables.REQUIREMENT_VERSION_LINK).join((TableLike)Tables.REQUIREMENT_VERSION_LINK_TYPE).on(Tables.REQUIREMENT_VERSION_LINK.LINK_TYPE_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.TYPE_ID)).join((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID.in(versionIds)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID, Tables.REQUIREMENT_VERSION_LINK.LINK_DIRECTION, Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_1, Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2, Tables.PROJECT.NAME, Tables.REQUIREMENT_VERSION.RES_ID, Tables.RESOURCE.NAME}).orderBy((OrderField)Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID, (OrderField)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_1, (OrderField)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2).fetchInto(ReqLink.class);
    }

    List<LowReq> getReqLinkedToHlrForHlrIds(List<Long> hlrIds) {
        return this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.as(REQ_ID), (SelectField)Tables.RESOURCE.RES_ID.as("VERSION_ID"), (SelectField)Tables.PROJECT.NAME.as("PROJECT"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as("REFERENCE"), (SelectField)Tables.RESOURCE.NAME.as("NAME"), (SelectField)DSL.groupConcat((Field)DSL.when((Condition)Tables.MILESTONE.LABEL.isNotNull(), (Field)DSL.concat((Field)Tables.MILESTONE.LABEL, (String)"=Sep=")).otherwise(null)).separator("=Sep=").as("MILESTONES"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY.as("CRITICALITY"), (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS")).from((TableLike)Tables.RESOURCE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_REQ_VERSION.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.in(hlrIds)).groupBy(new GroupField[]{Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID, Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_VERSION.CRITICALITY, Tables.PROJECT.NAME, Tables.REQUIREMENT_VERSION.REFERENCE, Tables.RESOURCE.NAME, Tables.REQUIREMENT_VERSION.RES_ID}).orderBy((OrderField)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID, (OrderField)Tables.REQUIREMENT_VERSION.CRITICALITY, (OrderField)Tables.PROJECT.NAME, (OrderField)Tables.REQUIREMENT_VERSION.REFERENCE, (OrderField)Tables.RESOURCE.NAME).fetchInto(LowReq.class);
    }

    String getMilestoneLabel(Integer milestoneId) {
        return (String)this.dsl.select((SelectField)Tables.MILESTONE.LABEL).from((TableLike)Tables.MILESTONE).where(Tables.MILESTONE.MILESTONE_ID.eq((Object)milestoneId)).fetchOne("LABEL", String.class);
    }

    String getMilestoneConfigurationQuery() {
        SelectConditionStep query = this.dsl.select((SelectField)Tables.CORE_CONFIG.VALUE).from((TableLike)Tables.CORE_CONFIG).where((Condition)Tables.CORE_CONFIG.STR_KEY.like("feature.milestone.enabled"));
        return (String)query.fetchOne((Field)Tables.CORE_CONFIG.VALUE);
    }
}

