/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.query;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.plugin.report.books.requirements.beans.AttachReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.Cuf;
import org.squashtest.tm.plugin.report.books.requirements.beans.Data;
import org.squashtest.tm.plugin.report.books.requirements.beans.LowReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.PrintOptions;
import org.squashtest.tm.plugin.report.books.requirements.beans.Project;
import org.squashtest.tm.plugin.report.books.requirements.beans.ReqLink;
import org.squashtest.tm.plugin.report.books.requirements.beans.Requirement;
import org.squashtest.tm.plugin.report.books.requirements.beans.RequirementLastVersion;
import org.squashtest.tm.plugin.report.books.requirements.beans.RequirementVersion;
import org.squashtest.tm.plugin.report.books.requirements.beans.TestCase;
import org.squashtest.tm.plugin.report.books.requirements.query.RequirementTreeQueryFinder;
import org.squashtest.tm.plugin.report.books.requirements.query.RequirementTreeQueryFormatter;

@Component(value="squashtest.tm.plugin.report.books.requirements.query.RequirementsTreeQuery")
public class RequirementsTreeQuery
implements ReportQuery {
    public static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTreeQuery.class);
    private static final String MILESTONES = "milestones";
    private static final String REQUIREMENTS_IDS = "requirementsIds";
    private static final String PROJECT_IDS = "projectIds";
    private static final String REQUIREMENTS_SELECTION_MODE = "requirementsSelectionMode";
    private static final String REPORT_OPTIONS = "reportOptions";
    private static final String REQUIREMENTS_SORT_ORDER = "requirementsSortOrder";
    private static final String TEMPLATE_FILE_NAME = "templateFileName";
    private static final String PRINT_ONLY_LAST_VERSION = "printOnlyLastVersion";
    private static final String PRINT_FOLDER_INFO = "printFolderInfo";
    private static final String PRINT_TEST_CASE = "printTestCase";
    private static final String PRINT_LINKED_REQ = "printLinkedReq";
    private static final String REQUIREMENT_FOLDERS = "requirement-folders";
    private static final String REQUIREMENTS = "requirements";
    private static final String HIGH_LEVEL_REQUIREMENTS = "high-level-requirements";
    private static final String TAGS = "tags";
    private static final String MILESTONE_PICKER = "MILESTONE_PICKER";
    private static final String DEFAULT_SORT_ORDER = "ALPHABETICAL";
    private static final String DEFAULT_TEMPLATE_VALUE = "defaultTemplate";
    public static final String PROJECT_PICKER = "PROJECT_PICKER";
    public static final String TAG_PICKER = "TAG_PICKER";
    private RequirementTreeQueryFinder queryFinder;
    private RequirementTreeQueryFormatter formatter;
    private CurrentUserHelper currentUserHelper;

    @Inject
    public RequirementsTreeQuery(RequirementTreeQueryFinder queryFinder, CurrentUserHelper currentUserHelper, AttachmentImageHelper attachmentImageHelper) {
        this.formatter = new RequirementTreeQueryFormatter(attachmentImageHelper);
        this.queryFinder = queryFinder;
        this.currentUserHelper = currentUserHelper;
    }

    public RequirementsTreeQuery() {
    }

    public void executeQuery(Map<String, Criteria> crit, Map<String, Object> res) {
        ArrayList<String> html = new ArrayList<String>();
        HashMap<String, Boolean> optionsMap = new HashMap<String, Boolean>();
        Criteria options = crit.get(REPORT_OPTIONS);
        optionsMap.put(PRINT_ONLY_LAST_VERSION, false);
        optionsMap.put(PRINT_FOLDER_INFO, false);
        optionsMap.put(PRINT_TEST_CASE, false);
        optionsMap.put(PRINT_LINKED_REQ, false);
        Collection selectedOptions = (Collection)options.getValue();
        for (String option : selectedOptions) {
            optionsMap.put(option, true);
        }
        String requirementsSortOrder = Objects.nonNull(crit.get(REQUIREMENTS_SORT_ORDER)) ? (String)crit.get(REQUIREMENTS_SORT_ORDER).getValue() : DEFAULT_SORT_ORDER;
        String templateFileName = this.retrieveTemplateFileName(crit.get(TEMPLATE_FILE_NAME));
        Boolean printOnlyLastVersion = (Boolean)optionsMap.get(PRINT_ONLY_LAST_VERSION);
        Boolean printFolderInfo = (Boolean)optionsMap.get(PRINT_FOLDER_INFO);
        Boolean printTestCase = (Boolean)optionsMap.get(PRINT_TEST_CASE);
        Boolean printLinkedReq = (Boolean)optionsMap.get(PRINT_LINKED_REQ);
        ArrayList<RequirementVersion> previousVersionsData = new ArrayList();
        List<Long> nodeIds = this.getNodeIdList(crit);
        List<Project> projectDataList = this.getProjectsData(crit);
        List<RequirementLastVersion> rawReqsData = this.queryFinder.getReqDataForRlnIds(nodeIds, requirementsSortOrder);
        String rawConfigurationData = this.queryFinder.getMilestoneConfigurationQuery();
        boolean printMilestones = this.formatter.rawMilestoneConfigToBoolean(rawConfigurationData);
        List<Requirement> reqsDataList = this.formatter.toRequirementData(rawReqsData, printMilestones);
        List<Requirement> hlrDataList = reqsDataList.stream().filter(Requirement::isHlr).toList();
        List<Long> versionAndFolderIds = this.getCurrentVersionAndFolderIds(reqsDataList);
        ArrayList<RequirementVersion> allVersions = new ArrayList<RequirementVersion>();
        this.extractVersions(reqsDataList, allVersions);
        if (!printOnlyLastVersion.booleanValue()) {
            List<String> rawPreviousVersionIds = this.queryFinder.getVersionIds(nodeIds);
            Set<Long> previousVersionIds = this.formatter.getPreviousVersionIds(rawPreviousVersionIds);
            versionAndFolderIds.addAll(previousVersionIds);
            previousVersionsData = this.queryFinder.getPreviousVersionsData(previousVersionIds);
            allVersions.addAll(previousVersionsData);
        }
        this.formatter.formatRequirementVersionData(allVersions, html);
        List<Cuf> cufList = this.queryFinder.getCufsDataForVersionIds(versionAndFolderIds);
        List<Cuf> tagCufList = this.queryFinder.getTagCufsDataForVersionIds(versionAndFolderIds);
        Map<Long, List<Cuf>> cufDataMap = this.formatter.toCufDataMap(cufList, html);
        Map<Long, List<Cuf>> tagCufDataMap = this.formatter.toCufDataMap(tagCufList, html);
        this.formatter.bindCufsToVersions(allVersions, cufDataMap);
        this.formatter.bindCufsToVersions(allVersions, tagCufDataMap);
        if (Boolean.TRUE.equals(printTestCase)) {
            List<TestCase> rawTestCase = this.queryFinder.getTestCasesDataForVersionIds(versionAndFolderIds);
            Map<Long, List<TestCase>> testCasesDataMap = this.formatter.toTestCaseDataMap(rawTestCase);
            this.formatter.bindTcToVersions(allVersions, testCasesDataMap);
        }
        if (Boolean.TRUE.equals(printLinkedReq)) {
            List<AttachReq> rawAttachReq = this.queryFinder.getAttachReqForReqIds(nodeIds);
            List<LowReq> rawReqLinkedToHlr = this.queryFinder.getReqLinkedToHlrForHlrIds(nodeIds);
            List<ReqLink> rawReqLink = this.queryFinder.getReqLinkDataQueryForVersionIds(versionAndFolderIds);
            Map<Long, List<AttachReq>> attachReqDataMap = this.formatter.toAttachReqDataMap(rawAttachReq);
            Map<Long, List<LowReq>> reqLinkedToHlrDataMap = this.formatter.toReqLinkedToHlrDataMap(rawReqLinkedToHlr);
            Map<Long, List<ReqLink>> reqLinkDataMap = this.formatter.toReqLinkDataMap(rawReqLink);
            this.formatter.bindAttachReqToReq(reqsDataList, attachReqDataMap);
            this.formatter.bindLowReqToHlr(hlrDataList, reqLinkedToHlrDataMap);
            this.formatter.bindReqLinkToVersions(allVersions, reqLinkDataMap);
        }
        if (!printOnlyLastVersion.booleanValue()) {
            this.formatter.bindVersionsToReq(reqsDataList, previousVersionsData);
        }
        if (Boolean.TRUE.equals(printTestCase)) {
            List<TestCase> testCaseToHLRList = this.queryFinder.getTestCasesDataForHLR(nodeIds);
            Map<Long, List<TestCase>> testCasesToHLRDataMap = this.formatter.toTestCaseDataMap(testCaseToHLRList);
            this.formatter.bindIndirectTestCaseToAllHighLevelRequirementVersions(hlrDataList, testCasesToHLRDataMap);
        }
        String milestoneLabel = null;
        if (this.isMilestonePicker(crit)) {
            List milestoneIds = (List)crit.get(MILESTONES).getValue();
            milestoneLabel = this.queryFinder.getMilestoneLabel((Integer)milestoneIds.getFirst());
            res.put("milestoneLabel", milestoneLabel);
        }
        if (printMilestones) {
            this.formatter.filterReqVersionForMilestone(reqsDataList, milestoneLabel);
        }
        this.formatter.bindReqToProject(projectDataList, reqsDataList);
        PrintOptions printOptions = new PrintOptions(requirementsSortOrder, templateFileName, printOnlyLastVersion, printFolderInfo, printTestCase, printLinkedReq, printMilestones);
        Data data = new Data(projectDataList, milestoneLabel, printOptions);
        res.put("fileName", data.getFileTitleRequirementsReport());
        res.put("data", data);
        res.put("html", html);
    }

    void extractVersions(Collection<Requirement> reqsDataList, Collection<RequirementVersion> allVersions) {
        for (Requirement req : reqsDataList) {
            allVersions.addAll(req.getVersions());
        }
    }

    List<Long> getCurrentVersionAndFolderIds(List<Requirement> reqsDataList) {
        return reqsDataList.stream().map(Requirement::getCurrentVersionId).collect(Collectors.toList());
    }

    private List<Project> getProjectsData(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        switch (selectionMode.getValue().toString()) {
            case "PROJECT_PICKER": {
                Criteria criteria = criteriaMap.get(PROJECT_IDS);
                Collection projectIdsAsString = (Collection)criteria.getValue();
                List<Long> projectIds = projectIdsAsString.stream().map(Long::valueOf).toList();
                return this.queryFinder.findProjects(projectIds);
            }
            case "MILESTONE_PICKER": {
                List milestoneIdsAsString = (List)criteriaMap.get(MILESTONES).getValue();
                List<Long> milestoneIds = milestoneIdsAsString.stream().map(Long::valueOf).toList();
                return this.queryFinder.findProjectsByMilestone(milestoneIds, this.currentUserHelper.findFilteredReadableProjectIds());
            }
            case "TAG_PICKER": {
                List tags = (List)criteriaMap.get(TAGS).getValue();
                return this.queryFinder.findProjectsByTags(tags, this.currentUserHelper.findFilteredReadableProjectIds());
            }
        }
        Collection<String> projectIdsAsString = this.getStrings(criteriaMap.get(REQUIREMENTS_IDS));
        List<Long> projectIds = projectIdsAsString.stream().map(Long::valueOf).toList();
        return this.queryFinder.findProjectsBySelection(projectIds);
    }

    private List<Long> getNodeIdList(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
        switch (selectionMode.getValue().toString()) {
            case "PROJECT_PICKER": {
                List<Long> projectIds = ((Collection)criteriaMap.get(PROJECT_IDS).getValue()).stream().map(Long::valueOf).toList();
                readableProjectIds.retainAll(projectIds);
                return this.queryFinder.findIdsByProject(readableProjectIds);
            }
            case "MILESTONE_PICKER": {
                List milestoneIds = (List)criteriaMap.get(MILESTONES).getValue();
                return this.queryFinder.findIdsByMilestone(milestoneIds, readableProjectIds);
            }
            case "TAG_PICKER": {
                List tags = (List)criteriaMap.get(TAGS).getValue();
                return this.queryFinder.findIdsByTags(tags, readableProjectIds);
            }
        }
        Criteria criteria = criteriaMap.get(REQUIREMENTS_IDS);
        Collection<String> allStrIds = this.getStrings(criteria);
        List<Long> allIds = allStrIds.stream().map(Long::valueOf).toList();
        return this.queryFinder.findIdsBySelection(allIds, readableProjectIds);
    }

    private Collection<String> getStrings(Criteria criteria) {
        ArrayList folderIds;
        Collection highLvlReqIds;
        Map selectedIds = (Map)criteria.getValue();
        ArrayList<String> allStrIds = (ArrayList<String>)selectedIds.get(REQUIREMENTS);
        if (allStrIds == null) {
            allStrIds = new ArrayList<String>();
        }
        if ((highLvlReqIds = (Collection)selectedIds.get(HIGH_LEVEL_REQUIREMENTS)) != null && !highLvlReqIds.isEmpty()) {
            allStrIds.addAll(highLvlReqIds);
        }
        if ((folderIds = (ArrayList)selectedIds.get(REQUIREMENT_FOLDERS)) == null) {
            folderIds = new ArrayList();
        }
        allStrIds.addAll(folderIds);
        return allStrIds;
    }

    private boolean isMilestonePicker(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        return MILESTONE_PICKER.equals(selectionMode.getValue());
    }

    private String retrieveTemplateFileName(Criteria templateCriteria) {
        if (Objects.nonNull(templateCriteria)) {
            try {
                return (String)templateCriteria.getValue();
            }
            catch (ClassCastException cce) {
                LOGGER.trace("Custom template file does not exist anymore.", (Throwable)cce);
            }
        }
        return DEFAULT_TEMPLATE_VALUE;
    }
}

