/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.plugin.report.books.requirements.beans.AttachReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.Cuf;
import org.squashtest.tm.plugin.report.books.requirements.beans.I18nHelper;
import org.squashtest.tm.plugin.report.books.requirements.beans.LowReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.Project;
import org.squashtest.tm.plugin.report.books.requirements.beans.ReqLink;
import org.squashtest.tm.plugin.report.books.requirements.beans.Requirement;
import org.squashtest.tm.plugin.report.books.requirements.beans.RequirementLastVersion;
import org.squashtest.tm.plugin.report.books.requirements.beans.RequirementVersion;
import org.squashtest.tm.plugin.report.books.requirements.beans.TestCase;
import org.squashtest.tm.plugin.report.books.requirements.util.Converter;

public class RequirementTreeQueryFormatter {
    private static final String REQLINK_RELATED = "requirement-version.link.type.related";
    private static final String REQLINK_PARENT = "requirement-version.link.type.parent";
    private static final String REQLINK_CHILD = "requirement-version.link.type.child";
    private static final String REQLINK_DUPLICATE = "requirement-version.link.type.duplicate";
    private static final String MILESTONE_SEPARATOR = ", ";
    private List<Integer> paragraphs;
    private String projectName;
    private final AttachmentImageHelper attachmentImageHelper;

    public RequirementTreeQueryFormatter(AttachmentImageHelper attachmentImageHelper) {
        this.attachmentImageHelper = attachmentImageHelper;
    }

    static <T> void addToMap(Long key, T data, Map<Long, List<T>> result) {
        if (result.get(key) == null) {
            result.put(key, new ArrayList<T>(Collections.singletonList(data)));
        } else {
            result.get(key).add(data);
        }
    }

    List<Requirement> toRequirementData(List<RequirementLastVersion> requirementLastVersionList, boolean printMilestones) {
        LinkedList<Requirement> result = new LinkedList<Requirement>();
        requirementLastVersionList.forEach(requirementLastVersion -> {
            Requirement newData = new Requirement();
            RequirementVersion lastVersion = new RequirementVersion();
            newData.setReqId(requirementLastVersion.getReqId());
            newData.setFolder(requirementLastVersion.isFolder());
            newData.setHlr(requirementLastVersion.isHlr());
            newData.setLevel(requirementLastVersion.getLevel());
            newData.setProjectId(requirementLastVersion.getProjectId());
            newData.setProjectName(requirementLastVersion.getProjectName());
            newData.setNumberOfVersions(requirementLastVersion.getNumberOfVersions());
            newData.setHighLevelReqLabel(requirementLastVersion.getHighLevelReqLabel());
            newData.setPrintMilestones(printMilestones);
            if (newData.isFolder()) {
                newData.setCurrentVersionId(newData.getReqId());
            } else {
                newData.setCurrentVersionId(requirementLastVersion.getVersionId());
            }
            newData.setCurrentVersionRef(requirementLastVersion.getReference());
            newData.setCurrentVersionName(requirementLastVersion.getName());
            if (newData.isFolder()) {
                lastVersion.setVersionId(newData.getReqId());
            } else {
                lastVersion.setVersionId(requirementLastVersion.getVersionId());
            }
            lastVersion.setReference(requirementLastVersion.getReference());
            lastVersion.setName(requirementLastVersion.getName());
            lastVersion.setVersionNumber(requirementLastVersion.getVersionNumber());
            lastVersion.setStatus(requirementLastVersion.getStatus());
            lastVersion.setCriticality(requirementLastVersion.getCriticality());
            lastVersion.setCategory(requirementLastVersion.getCategory());
            lastVersion.setCategoryType(requirementLastVersion.getCategoryType());
            lastVersion.setCreatedBy(requirementLastVersion.getCreatedBy());
            lastVersion.setCreatedOn(requirementLastVersion.getCreatedOn());
            lastVersion.setModifyBy(requirementLastVersion.getModifiedBy());
            lastVersion.setModifyOn(requirementLastVersion.getModifiedOn());
            lastVersion.setMilestones(requirementLastVersion.getMilestones().replace(",", MILESTONE_SEPARATOR));
            lastVersion.setAttachments(requirementLastVersion.getAttachments());
            lastVersion.setDescription(requirementLastVersion.getDescription());
            lastVersion.setNature(newData.isHlr());
            newData.addLastVersion(lastVersion);
            result.add(newData);
        });
        return result;
    }

    boolean rawMilestoneConfigToBoolean(String rawConfigurationData) {
        if (Objects.isNull(rawConfigurationData)) {
            return false;
        }
        return "true".equalsIgnoreCase(rawConfigurationData);
    }

    Map<Long, List<TestCase>> toTestCaseDataMap(List<TestCase> testCaseList) {
        HashMap<Long, List<TestCase>> result = new HashMap<Long, List<TestCase>>();
        testCaseList.forEach(testCase -> RequirementTreeQueryFormatter.addToMap(testCase.getReqId(), testCase, result));
        return result;
    }

    Map<Long, List<AttachReq>> toAttachReqDataMap(List<AttachReq> attachReqList) {
        HashMap<Long, List<AttachReq>> result = new HashMap<Long, List<AttachReq>>();
        attachReqList.forEach(attachReq -> RequirementTreeQueryFormatter.addToMap(attachReq.getReqId(), attachReq, result));
        return result;
    }

    Map<Long, List<Cuf>> toCufDataMap(List<Cuf> cufs, List<String> html) {
        Converter converter = new Converter(this.attachmentImageHelper);
        HashMap<Long, List<Cuf>> result = new HashMap<Long, List<Cuf>>();
        cufs.forEach(cuf -> {
            if ("RTF".equals(cuf.getType())) {
                cuf.setValue(converter.from(cuf.getValue()).toRichText(html));
            }
            RequirementTreeQueryFormatter.addToMap(cuf.getBoundEntityId(), cuf, result);
        });
        return result;
    }

    Map<Long, List<ReqLink>> toReqLinkDataMap(List<ReqLink> reqLinkList) {
        HashMap<Long, List<ReqLink>> result = new HashMap<Long, List<ReqLink>>();
        reqLinkList.forEach(reqLink -> {
            String role1 = reqLink.getRole1();
            String role2 = reqLink.getRole2();
            if (role1.equals(REQLINK_RELATED) || role1.equals(REQLINK_PARENT) || role1.equals(REQLINK_CHILD) || role1.equals(REQLINK_DUPLICATE)) {
                role1 = I18nHelper.translate(role1);
                role2 = I18nHelper.translate(role2);
            }
            if (reqLink.isLinkDirection()) {
                reqLink.setRole(role1);
            } else {
                reqLink.setRole(role2);
            }
            RequirementTreeQueryFormatter.addToMap(reqLink.getReqId(), reqLink, result);
        });
        return result;
    }

    void formatRequirementVersionData(List<RequirementVersion> requirementVersionData, List<String> html) {
        Converter converter = new Converter(this.attachmentImageHelper);
        requirementVersionData.forEach(requirementVersion -> requirementVersion.setDescription(converter.from(requirementVersion.getDescription()).toRichText(html)));
    }

    public Map<Long, List<LowReq>> toReqLinkedToHlrDataMap(List<LowReq> lowReqList) {
        HashMap<Long, List<LowReq>> result = new HashMap<Long, List<LowReq>>();
        lowReqList.forEach(lowReq -> RequirementTreeQueryFormatter.addToMap(lowReq.getReqId(), lowReq, result));
        return result;
    }

    public void bindReqToProject(Collection<Project> projectDataList, Collection<Requirement> reqDataList) {
        if (!projectDataList.isEmpty()) {
            this.paragraphs = new ArrayList<Integer>();
            this.projectName = Objects.requireNonNull(projectDataList.stream().findFirst().orElse(null)).getProjectName();
            for (Project project : projectDataList) {
                project.setRequirements(this.groupReqForProject(project.getProjectId(), reqDataList));
            }
        }
    }

    private Collection<Requirement> groupReqForProject(Long projectId, Collection<Requirement> requirementCollection) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (Requirement req : requirementCollection) {
            if (!req.getProjectId().equals(projectId)) continue;
            if (!this.projectName.equals(req.getProjectName())) {
                this.paragraphs = new ArrayList<Integer>();
                this.projectName = req.getProjectName();
            }
            this.changeParagraph(req);
            req.setParagraph(this.paragraphs);
            requirements.add(req);
        }
        return requirements;
    }

    private void changeParagraph(Requirement requirement) {
        int level = requirement.getLevel().intValue();
        if (this.paragraphs.isEmpty()) {
            this.paragraphs.add(1);
        } else if (this.paragraphs.size() == level) {
            this.paragraphs.add(1);
        } else {
            int index = this.paragraphs.size();
            while (index > level + 1) {
                this.paragraphs.remove(index - 1);
                --index;
            }
            this.paragraphs.set(level, this.paragraphs.get(level) + 1);
        }
    }

    public void bindVersionsToReq(Collection<Requirement> reqDataList, Collection<RequirementVersion> versionDataList) {
        for (Requirement requirement : reqDataList) {
            requirement.addPreviousVersions(this.groupVersionForReq(requirement, versionDataList));
            requirement.orderVersions();
        }
    }

    private Collection<RequirementVersion> groupVersionForReq(Requirement req, Collection<RequirementVersion> versionDataList) {
        ArrayList<RequirementVersion> versions = new ArrayList<RequirementVersion>();
        for (RequirementVersion version : versionDataList) {
            if (!version.getReqId().equals(req.getReqId())) continue;
            version.setNature(req.isHlr());
            versions.add(version);
        }
        return versions;
    }

    public void bindCufsToVersions(Collection<RequirementVersion> allVersions, Map<Long, List<Cuf>> cufsDataMap) {
        for (RequirementVersion version : allVersions) {
            if (cufsDataMap.get(version.getVersionId()) == null) continue;
            version.getCufs().addAll((Collection<Cuf>)cufsDataMap.get(version.getVersionId()));
        }
    }

    public void bindTcToVersions(Collection<RequirementVersion> allVersions, Map<Long, List<TestCase>> testCasesDataMap) {
        for (RequirementVersion version : allVersions) {
            version.setTestCases(testCasesDataMap.get(version.getVersionId()));
            version.orderTestCases();
        }
    }

    public void bindTcToHLRVersions(Collection<RequirementVersion> allVersions, Map<Long, List<TestCase>> testCasesDataMap) {
        for (RequirementVersion version : allVersions) {
            version.setTestCases(testCasesDataMap.get(version.getVersionId()));
            version.orderTestCases();
        }
    }

    public void bindIndirectTestCaseToAllHighLevelRequirementVersions(Collection<Requirement> requirements, Map<Long, List<TestCase>> testCasesDataMap) {
        for (Requirement requirement : requirements) {
            if (!testCasesDataMap.containsKey(requirement.getReqId())) continue;
            for (RequirementVersion version : requirement.getVersions()) {
                this.bindIndirectTestCaseToHLReqVersion(testCasesDataMap, requirement, version);
            }
        }
    }

    private void bindIndirectTestCaseToHLReqVersion(Map<Long, List<TestCase>> testCasesDataMap, Requirement requirement, RequirementVersion version) {
        List<TestCase> boundTestCasesToHlReq = testCasesDataMap.get(requirement.getReqId());
        if (version.isHasTestCases()) {
            this.addNotLinkedTestCase(boundTestCasesToHlReq, version);
        } else {
            version.setTestCases(boundTestCasesToHlReq);
        }
        version.orderTestCases();
    }

    private void addNotLinkedTestCase(List<TestCase> boundTestCasesToHlReq, RequirementVersion version) {
        for (TestCase tc : boundTestCasesToHlReq) {
            boolean versionAlreadyHasThisTC = version.getTestCases().stream().anyMatch(testCase2 -> Objects.equals(testCase2.getTcId(), tc.getTcId()));
            if (versionAlreadyHasThisTC) continue;
            version.getTestCases().add(tc);
        }
    }

    public void bindAttachReqToReq(Collection<Requirement> requirements, Map<Long, List<AttachReq>> attachReqDataMap) {
        for (Requirement req : requirements) {
            req.setAttachReqs(attachReqDataMap.get(req.getReqId()));
        }
    }

    public void bindReqLinkToVersions(Collection<RequirementVersion> allVersions, Map<Long, List<ReqLink>> reqLinkDataMap) {
        for (RequirementVersion version : allVersions) {
            version.setReqLinks(reqLinkDataMap.get(version.getVersionId()));
        }
    }

    public void bindLowReqToHlr(Collection<Requirement> reqsDataList, Map<Long, List<LowReq>> reqLinkedToHlrDataMap) {
        for (Requirement req : reqsDataList) {
            req.setLowReqs(reqLinkedToHlrDataMap.get(req.getReqId()));
        }
    }

    public Set<Long> getPreviousVersionIds(List<String> versionIdsAsString) {
        Converter converter = new Converter(this.attachmentImageHelper);
        HashSet<Long> previousVersionIds = new HashSet<Long>();
        versionIdsAsString.forEach(versionId -> {
            boolean bl = previousVersionIds.addAll(converter.fromStringToIdList((String)versionId));
        });
        return previousVersionIds;
    }
}

