/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.beans;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;

@Component(value="report.books.requirements.i18nHelper")
public class I18nHelper
implements MessageSourceAware {
    public static final String REQUIREMENT_CRITICALITY = "requirement.criticality.";
    public static final String REQUIREMENT_STATUS = "requirement.status.";
    public static final String TEST_CASE_STATUS = "test-case.status.";
    public static final String TEST_CASE_IMPORTANCE = "test-case.importance.";
    private static MessageSource msgSource;

    private static Locale currentLocale() {
        return LocaleContextHolder.getLocale();
    }

    public static String translate(String string) {
        return msgSource.getMessage(string, null, I18nHelper.currentLocale());
    }

    public static String translate(String string, Object[] params) {
        return msgSource.getMessage(string, params, I18nHelper.currentLocale());
    }

    public static String translate(Date date) {
        String dateFormat = msgSource.getMessage("squashtm.dateformat", null, I18nHelper.currentLocale());
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public void setMessageSource(@NonNull MessageSource messageSource) {
        msgSource = messageSource;
    }

    public String getRequirementCategory(String category, String categoryType) {
        if ("SYS".equals(categoryType)) {
            return I18nHelper.translate(category);
        }
        return category;
    }

    public String getRequirementCriticality(String criticality) {
        RequirementCriticality criticalityEnum = this.getRequirementCriticalityEnum(criticality);
        return switch (criticalityEnum) {
            case RequirementCriticality.MAJOR -> I18nHelper.translate("requirement.criticality.MAJOR");
            case RequirementCriticality.MINOR -> I18nHelper.translate("requirement.criticality.MINOR");
            case RequirementCriticality.CRITICAL -> I18nHelper.translate("requirement.criticality.CRITICAL");
            case RequirementCriticality.UNDEFINED -> I18nHelper.translate("requirement.criticality.UNDEFINED");
            default -> throw new MatchException(null, null);
        };
    }

    private RequirementCriticality getRequirementCriticalityEnum(String criticality) {
        if (Objects.nonNull(criticality) && Arrays.stream(RequirementCriticality.values()).anyMatch(e -> e.name().equals(criticality))) {
            return RequirementCriticality.valueOf((String)criticality);
        }
        return RequirementCriticality.UNDEFINED;
    }

    public String getRequirementStatus(String status) {
        RequirementStatus requirementStatusEnum = this.getRequirementStatusEnum(status);
        return switch (requirementStatusEnum) {
            case RequirementStatus.APPROVED -> I18nHelper.translate("requirement.status.APPROVED");
            case RequirementStatus.OBSOLETE -> I18nHelper.translate("requirement.status.OBSOLETE");
            case RequirementStatus.UNDER_REVIEW -> I18nHelper.translate("requirement.status.UNDER_REVIEW");
            case RequirementStatus.WORK_IN_PROGRESS -> I18nHelper.translate("requirement.status.WORK_IN_PROGRESS");
            default -> throw new MatchException(null, null);
        };
    }

    private RequirementStatus getRequirementStatusEnum(String status) {
        if (Objects.nonNull(status) && Arrays.stream(RequirementStatus.values()).anyMatch(e -> e.name().equals(status))) {
            return RequirementStatus.valueOf((String)status);
        }
        return RequirementStatus.WORK_IN_PROGRESS;
    }

    public String getTestCaseStatus(String status) {
        TestCaseStatus testCaseStatusEnum = this.getTestCaseStatusEnum(status);
        return switch (testCaseStatusEnum) {
            case TestCaseStatus.TO_BE_UPDATED -> I18nHelper.translate("test-case.status.TO_BE_UPDATED");
            case TestCaseStatus.UNDER_REVIEW -> I18nHelper.translate("test-case.status.UNDER_REVIEW");
            case TestCaseStatus.APPROVED -> I18nHelper.translate("test-case.status.APPROVED");
            case TestCaseStatus.OBSOLETE -> I18nHelper.translate("test-case.status.OBSOLETE");
            case TestCaseStatus.WORK_IN_PROGRESS -> I18nHelper.translate("test-case.status.WORK_IN_PROGRESS");
            default -> throw new MatchException(null, null);
        };
    }

    private TestCaseStatus getTestCaseStatusEnum(String status) {
        if (Objects.nonNull(status) && Arrays.stream(TestCaseStatus.values()).anyMatch(it -> it.name().equals(status))) {
            return TestCaseStatus.valueOf((String)status);
        }
        return TestCaseStatus.WORK_IN_PROGRESS;
    }

    public String getTestCaseImportance(String importance) {
        TestCaseImportance testCaseImportanceEnum = this.getTestCaseImportanceEnum(importance);
        return switch (testCaseImportanceEnum) {
            case TestCaseImportance.VERY_HIGH -> I18nHelper.translate("test-case.importance.VERY_HIGH");
            case TestCaseImportance.HIGH -> I18nHelper.translate("test-case.importance.HIGH");
            case TestCaseImportance.MEDIUM -> I18nHelper.translate("test-case.importance.MEDIUM");
            case TestCaseImportance.LOW -> I18nHelper.translate("test-case.importance.LOW");
            default -> throw new MatchException(null, null);
        };
    }

    private TestCaseImportance getTestCaseImportanceEnum(String importance) {
        if (Objects.nonNull(importance) && Arrays.stream(TestCaseImportance.values()).anyMatch(it -> it.name().equals(importance))) {
            return TestCaseImportance.valueOf((String)importance);
        }
        return TestCaseImportance.LOW;
    }

    public static MessageSource getMsgSource() {
        return msgSource;
    }

    public static void setMsgSource(MessageSource msgSource) {
        I18nHelper.msgSource = msgSource;
    }
}

