/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements;

import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;
import org.squashtest.tm.api.report.DocxTemplaterReport;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.ReportPlugin;
import org.squashtest.tm.api.report.ReportView;
import org.squashtest.tm.api.report.StandardReportCategory;
import org.squashtest.tm.api.report.StandardReportType;
import org.squashtest.tm.api.report.docxtemplater.DocxTemplaterView;
import org.squashtest.tm.api.report.form.CheckboxesGroup;
import org.squashtest.tm.api.report.form.Form;
import org.squashtest.tm.api.report.form.Input;
import org.squashtest.tm.api.report.form.NodeType;
import org.squashtest.tm.api.report.form.OptionInput;
import org.squashtest.tm.api.report.form.RadioButtonsGroup;
import org.squashtest.tm.api.report.form.TemplateDropdownList;
import org.squashtest.tm.api.report.form.composite.MilestonePickerOption;
import org.squashtest.tm.api.report.form.composite.ProjectPickerOption;
import org.squashtest.tm.api.report.form.composite.TagPickerOption;
import org.squashtest.tm.api.report.form.composite.TreePickerOption;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.report.spring.view.docxtemplater.DocxTemplaterDocxView;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.plugin.report.books.requirements.query.RequirementTreeQueryFinder;
import org.squashtest.tm.plugin.report.books.requirements.query.RequirementTreeQueryFormatter;
import org.squashtest.tm.plugin.report.books.requirements.query.RequirementsTreeQuery;

@Configuration
public class RequirementsBooksReportConfig {
    private final RequirementTreeQueryFinder queryFinder;
    private final CurrentUserHelper currentUserHelper;
    private final MessageSource messageSource;

    public RequirementsBooksReportConfig(RequirementTreeQueryFinder queryFinder, CurrentUserHelper currentUserHelper, MessageSource messageSource) {
        this.queryFinder = queryFinder;
        this.currentUserHelper = currentUserHelper;
        this.messageSource = messageSource;
    }

    @Bean(name={"squash.tm.report.requirements.editable"})
    public ReportPlugin requirementsReportPlugin(DocxTemplaterReport editableRequirementsTree) {
        ReportPlugin plugin = new ReportPlugin();
        plugin.setReports(new Report[]{editableRequirementsTree});
        return plugin;
    }

    @Bean(name={"editableRequirementsTree"})
    public DocxTemplaterReport editableRequirementsTree(RequirementsTreeQuery editableRequirementsTreeQuery, DocxTemplaterDocxView editableRequirementsReportView, Form reqForm) {
        DocxTemplaterReport report = new DocxTemplaterReport();
        report.setCategory(StandardReportCategory.PREPARATION_PHASE);
        report.setType(StandardReportType.SPECIFICATION_BOOK);
        report.setLabelKey("report.books.requirements.requirements.report.label");
        report.setDescriptionKey("report.books.requirements.requirements.report.description");
        report.setCustomTemplateFolderPath("${squash.report-custom-template.folder-path}/report.books.requirements/");
        report.setDefaultTemplateFilePath("classpath:template/report.books.requirements.template.docx");
        DocxTemplaterView docxView = new DocxTemplaterView();
        docxView.setLabelKey("report.books.requirements.view.title.requirements.report");
        docxView.setFormats(new String[]{"docx"});
        docxView.setQuery((ReportQuery)editableRequirementsTreeQuery);
        docxView.setSpringView((View)editableRequirementsReportView);
        report.setViews(new ReportView[]{docxView});
        report.setForm(reqForm.getInputs().toArray(new Input[reqForm.getInputs().size()]));
        return report;
    }

    @Bean
    public Form reqForm(@Named(value="editableRequirementstemplateFileName") TemplateDropdownList editableRequirementstemplateFileName, @Named(value="editableRequirementsSelectionMode") RadioButtonsGroup editableRequirementsSelectionMode, @Named(value="editableRequirementsSortOrder") RadioButtonsGroup editableRequirementsSortOrder, @Named(value="editableRequirementsReportOptions") CheckboxesGroup editableRequirementsReportOptions) {
        Form form = new Form();
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.add(editableRequirementstemplateFileName);
        inputs.add(editableRequirementsSelectionMode);
        inputs.add(editableRequirementsSortOrder);
        inputs.add(editableRequirementsReportOptions);
        form.setInputs(inputs);
        return form;
    }

    @Bean(name={"editableRequirementstemplateFileName"})
    public TemplateDropdownList editableRequirementstemplateFileName() {
        TemplateDropdownList dropdown = new TemplateDropdownList();
        dropdown.setName("templateFileName");
        dropdown.setLabelKey("report.books.requirements.report.criteria.panel.requirements.template.label");
        dropdown.setFolderPath("${squash.report-custom-template.folder-path}/report.books.requirements/");
        dropdown.setFileDoesNotExistMessageKey("report.books.requirements.report.criteria.panel.requirements.file-does-not-exist.message");
        ArrayList<OptionInput> options = new ArrayList<OptionInput>();
        OptionInput defaultOption = new OptionInput();
        defaultOption.setValue("defaultTemplate");
        defaultOption.setDefaultSelected(true);
        defaultOption.setLabelKey("report.books.requirements.report.criteria.panel.requirements.default-template.label");
        defaultOption.setMessageSource(this.messageSource);
        options.add(defaultOption);
        dropdown.setOptions(options);
        return dropdown;
    }

    @Bean(name={"editableRequirementsSelectionMode"})
    public RadioButtonsGroup editableRequirementsSelectionMode() {
        RadioButtonsGroup group = new RadioButtonsGroup();
        group.setName("requirementsSelectionMode");
        group.setLabelKey("report.books.requirements.report.criteria.panel.requirements.list.selection.label");
        group.setRequired(true);
        group.setOptions(List.of(this.generateProjectPickerOption(), this.generateTreePickerOption(), this.generateMilestonePickerOption(), this.generateTagPickerOption()));
        return group;
    }

    @Bean(name={"editableRequirementsProjectPickerOption"})
    public ProjectPickerOption generateProjectPickerOption() {
        ProjectPickerOption projectOption = new ProjectPickerOption();
        projectOption.setLabelKey("report.books.requirements.report.criteria.panel.requirements.list.selection.project.label");
        projectOption.setPickerName("projectIds");
        projectOption.setPickerLabelKey("report.books.requirements.report.criteria.panel.projectlist.label");
        projectOption.setDefaultSelected(true);
        projectOption.setMessageSource(this.messageSource);
        return projectOption;
    }

    @Bean(name={"editableRequirementsTreePickerOption"})
    public TreePickerOption generateTreePickerOption() {
        TreePickerOption nodeOption = new TreePickerOption();
        nodeOption.setLabelKey("report.books.requirements.report.criteria.panel.requirements.list.selection.node.label");
        nodeOption.setPickerLabelKey("report.books.requirements.requirements.report.criteria.panel.requirementsList.picker.label");
        nodeOption.setPickerName("requirementsIds");
        nodeOption.setPickedNodeType(NodeType.REQUIREMENT);
        nodeOption.setMessageSource(this.messageSource);
        return nodeOption;
    }

    @Bean(name={"editableRequirementsMilestonePickerOption"})
    public MilestonePickerOption generateMilestonePickerOption() {
        MilestonePickerOption milestoneOption = new MilestonePickerOption();
        milestoneOption.setLabelKey("report.books.requirements.requirements.report.criteria.panel.milestone.label");
        milestoneOption.setPickerLabelKey("report.books.requirements.requirements.report.criteria.panel.milestone.label");
        milestoneOption.setPickerName("milestones");
        milestoneOption.setMessageSource(this.messageSource);
        return milestoneOption;
    }

    @Bean(name={"editableRequirementsTagPickerOption"})
    public TagPickerOption generateTagPickerOption() {
        TagPickerOption tagOption = new TagPickerOption();
        tagOption.setLabelKey("report.books.requirements.report.criteria.panel.tag.label");
        tagOption.setPickerLabelKey("report.books.requirements.report.criteria.panel.tag.label");
        tagOption.setPickerName("tags");
        tagOption.setPickerBoundEntity("REQUIREMENT_VERSION");
        tagOption.setMessageSource(this.messageSource);
        return tagOption;
    }

    @Bean(name={"editableRequirementsSortOrder"})
    public RadioButtonsGroup editableRequirementsSortOrder() {
        RadioButtonsGroup group = new RadioButtonsGroup();
        group.setName("requirementsSortOrder");
        group.setLabelKey("report.books.requirements.report.criteria.panel.requirements.sortOrder.label");
        group.setRequired(true);
        OptionInput positional = new OptionInput();
        positional.setLabelKey("report.books.requirements.report.criteria.panel.requirements.sortOrder.positional.label");
        positional.setValue("POSITIONAL");
        positional.setGivesAccessTo("POSITIONAL");
        positional.setMessageSource(this.messageSource);
        OptionInput alphabetical = new OptionInput();
        alphabetical.setLabelKey("report.books.requirements.report.criteria.panel.requirements.sortOrder.alphabetical.label");
        alphabetical.setValue("ALPHABETICAL");
        alphabetical.setGivesAccessTo("ALPHABETICAL");
        alphabetical.setDefaultSelected(true);
        alphabetical.setMessageSource(this.messageSource);
        group.setOptions(List.of(alphabetical, positional));
        return group;
    }

    @Bean(name={"editableRequirementsReportOptions"})
    public CheckboxesGroup editableRequirementsReportOptions() {
        CheckboxesGroup group = new CheckboxesGroup();
        group.setName("reportOptions");
        group.setLabelKey("report.books.requirements.criteria.options");
        group.setOptions(List.of(this.createOptionInput("report.books.requirements.criteria.option.printonlylastversion", "printOnlyLastVersion", "chk-printonlylastversion"), this.createOptionInput("report.books.requirements.criteria.option.printFolder", "printFolderInfo", "chk-printFolderInfo"), this.createOptionInput("report.books.requirements.criteria.option.printTestCase", "printTestCase", "chk-printtestcase"), this.createOptionInput("report.books.requirements.criteria.option.printLinkedReq", "printLinkedReq", "chk-printlinkedReq")));
        return group;
    }

    private OptionInput createOptionInput(String labelKey, String value, String access) {
        OptionInput optionInput = new OptionInput();
        optionInput.setLabelKey(labelKey);
        optionInput.setValue(value);
        optionInput.setDefaultSelected(true);
        optionInput.setGivesAccessTo(access);
        optionInput.setMessageSource(this.messageSource);
        return optionInput;
    }

    @Bean(name={"editableRequirementsTreeQuery"})
    public RequirementsTreeQuery editableRequirementsTreeQuery() {
        return new RequirementsTreeQuery(this.queryFinder, this.currentUserHelper);
    }

    @Bean
    public RequirementTreeQueryFormatter requirementsTreeQueryFormatter(AttachmentImageHelper attachmentImageHelper) {
        RequirementTreeQueryFormatter formatter = new RequirementTreeQueryFormatter();
        formatter.setAttachmentImageHelper(attachmentImageHelper);
        return formatter;
    }

    @Bean(name={"editableRequirementsReportView"})
    public DocxTemplaterDocxView editableRequirementsReportView() {
        return new DocxTemplaterDocxView();
    }
}

