--
--     This file is part of the Squashtest platform.
--     Copyright (C) Henix, henix.fr
--
--     See the NOTICE file distributed with this work for additional
--     information regarding copyright ownership.
--
--     This is free software: you can redistribute it and/or modify
--     it under the terms of the GNU Lesser General Public License as published by
--     the Free Software Foundation, either version 3 of the License, or
--     (at your option) any later version.
--
--     this software is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU Lesser General Public License for more details.
--
--     You should have received a copy of the GNU Lesser General Public License
--     along with this software.  If not, see <http://www.gnu.org/licenses/>.
--

select CFV.BOUND_ENTITY_ID,
       CFV.FIELD_TYPE,
       CF.LABEL,
       case when CFV.FIELD_TYPE!='RTF'then CFV.VALUE else CFV.LARGE_VALUE end as value,
	   CF.INPUT_TYPE
from CUSTOM_FIELD_VALUE CFV
join CUSTOM_FIELD CF on CFV.CF_ID = CF.CF_ID
join CUSTOM_FIELD_BINDING CFB on CFB.CFB_ID = CFV.CFB_ID
where CFV.BOUND_ENTITY_ID in (:versionIds)
and CFV.BOUND_ENTITY_TYPE in ('REQUIREMENT_FOLDER', 'REQUIREMENT_VERSION')
and CFV.FIELD_TYPE != 'TAG'
GROUP BY CFV.CFV_ID, CF.LABEL, CF.INPUT_TYPE, CFV.BOUND_ENTITY_TYPE, CFB.POSITION, CFV.BOUND_ENTITY_ID
order by CFV.BOUND_ENTITY_ID, CFB.POSITION
