/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.query;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.plugin.report.books.requirements.beans.AttachReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.Cuf;
import org.squashtest.tm.plugin.report.books.requirements.beans.I18nHelper;
import org.squashtest.tm.plugin.report.books.requirements.beans.LowReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.Project;
import org.squashtest.tm.plugin.report.books.requirements.beans.ReqLink;
import org.squashtest.tm.plugin.report.books.requirements.beans.Requirement;
import org.squashtest.tm.plugin.report.books.requirements.beans.RequirementVersion;
import org.squashtest.tm.plugin.report.books.requirements.beans.TestCase;

public class RequirementTreeQueryFormatter {
    private static final String REQLINK_RELATED = "requirement-version.link.type.related";
    private static final String REQLINK_PARENT = "requirement-version.link.type.parent";
    private static final String REQLINK_CHILD = "requirement-version.link.type.child";
    private static final String REQLINK_DUPLICATE = "requirement-version.link.type.duplicate";
    private static final String END_TEXT_SEPARATOR = "=Sep=";
    private static final String MILESTONE_SEPARATOR = ", ";
    private static final int MAX_IMAGE_SIZE = 700;
    private List<Integer> paragraphs;
    private String projectName;
    private AttachmentImageHelper attachmentImageHelper;

    public void setAttachmentImageHelper(AttachmentImageHelper attachmentImageHelper) {
        this.attachmentImageHelper = attachmentImageHelper;
    }

    static <T> void addToMap(Long key, T data, Map<Long, List<T>> result) {
        if (result.get(key) == null) {
            result.put(key, new ArrayList<T>(Collections.singletonList(data)));
        } else {
            result.get(key).add(data);
        }
    }

    Collection<Project> toProjectData(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        ArrayList<Project> result = new ArrayList<Project>(tuples.size());
        for (Object[] array : tuples) {
            Project newData = new Project();
            Long id = konvertor.from(array[0]).toLong();
            String name = konvertor.from(array[1]).toString();
            newData.setProjectId(id);
            newData.setProjectName(name);
            result.add(newData);
        }
        return result;
    }

    Collection<Requirement> toRequirementData(Collection<Object[]> tuples, List<String> html, boolean printMilestones) {
        Konvertor konvertor = new Konvertor();
        LinkedList<Requirement> result = new LinkedList<Requirement>();
        for (Object[] array : tuples) {
            Requirement newData = new Requirement();
            RequirementVersion lastVersion = new RequirementVersion();
            newData.setReqId(konvertor.from(array[0]).toLong());
            newData.setFolder(konvertor.from(array[1]).toLong());
            newData.setHlr(konvertor.from(array[2]).toLong());
            newData.setLevel(konvertor.from(array[3]).toLong());
            newData.setProjectId(konvertor.from(array[5]).toLong());
            newData.setProjectName(konvertor.from(array[6]).toString());
            newData.setNumberOfVersions(konvertor.from(array[7]).toLong());
            newData.setHighLevelReqLabel(konvertor.from(array[8]).toString());
            newData.setPrintMilestones(printMilestones);
            if (newData.isFolder()) {
                newData.setCurrentVersionId(newData.getReqId());
            } else {
                newData.setCurrentVersionId(konvertor.from(array[9]).toLong());
            }
            newData.setCurrentVersionRef(konvertor.from(array[10]).toString());
            newData.setCurrentVersionName(konvertor.from(array[11]).toString());
            if (newData.isFolder()) {
                lastVersion.setVersionId(newData.getReqId());
            } else {
                lastVersion.setVersionId(konvertor.from(array[9]).toLong());
            }
            lastVersion.setReference(konvertor.from(array[10]).toString());
            lastVersion.setName(konvertor.from(array[11]).toString());
            lastVersion.setVersionNumber(konvertor.from(array[12]).toLong());
            lastVersion.setStatus(konvertor.from(array[13]).toString());
            lastVersion.setCriticality(konvertor.from(array[14]).toString());
            lastVersion.setCategory(konvertor.from(array[15]).toString());
            lastVersion.setCategoryType(konvertor.from(array[16]).toString());
            lastVersion.setCreatedBy(konvertor.from(array[17]).toString());
            lastVersion.setCreatedOn(konvertor.from(array[18]).toDate());
            lastVersion.setModifyBy(konvertor.from(array[19]).toString());
            lastVersion.setModifyOn(konvertor.from(array[20]).toDate());
            String milestones = konvertor.from(array[21]).toString();
            lastVersion.setMilestones(milestones.replace(",", MILESTONE_SEPARATOR));
            lastVersion.setAttachments(konvertor.from(array[22]).toLong());
            lastVersion.setDescription(konvertor.from(array[23]).toRichText(html));
            lastVersion.setNature(newData.isHlr());
            newData.addLastVersion(lastVersion);
            result.add(newData);
        }
        return result;
    }

    boolean rawMilestoneConfigToBoolean(Collection<Object[]> rawConfigurationData) {
        Konvertor konvertor = new Konvertor();
        if (rawConfigurationData.isEmpty()) {
            return false;
        }
        if (rawConfigurationData.size() == 1) {
            Object[] array = rawConfigurationData.iterator().next();
            String value = konvertor.from(array[1]).toString();
            return "true".equalsIgnoreCase(value);
        }
        throw new IndexOutOfBoundsException("bug : sql query results exceed expected quantity, returned: " + rawConfigurationData.size());
    }

    Map<Long, List<TestCase>> toTestCaseDataMap(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        HashMap result = new HashMap();
        for (Object[] array : tuples) {
            TestCase data = new TestCase();
            data.setTcId(konvertor.from(array[0]).toLong());
            data.setProjectName(konvertor.from(array[2]).toString());
            data.setTcRef(konvertor.from(array[3]).toString());
            data.setTcName(konvertor.from(array[4]).toString());
            data.setTcMilestone(konvertor.from(array[5]).toString());
            data.setTcStatus(konvertor.from(array[6]).toString());
            data.setTcImportance(konvertor.from(array[7]).toString());
            RequirementTreeQueryFormatter.addToMap(konvertor.from(array[1]).toLong(), data, result);
        }
        return result;
    }

    Map<Long, List<AttachReq>> toAttachReqDataMap(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        HashMap result = new HashMap();
        for (Object[] array : tuples) {
            AttachReq data = new AttachReq();
            data.setReference(konvertor.from(array[2]).toString());
            data.setName(konvertor.from(array[3]).toString());
            data.setMilestones(konvertor.from(array[4]).toString());
            data.setCriticality(konvertor.from(array[5]).toString());
            data.setParent(konvertor.from(array[6]).toLong());
            RequirementTreeQueryFormatter.addToMap(konvertor.from(array[0]).toLong(), data, result);
        }
        return result;
    }

    Map<Long, List<Cuf>> toCufDataMap(Collection<Object[]> tuples, List<String> html) {
        Konvertor konvertor = new Konvertor();
        HashMap result = new HashMap();
        for (Object[] array : tuples) {
            Cuf data = new Cuf();
            data.setType(konvertor.from(array[1]).toString());
            data.setLabel(konvertor.from(array[2]).toString());
            if ("RTF".equals(data.getType())) {
                data.setValue(konvertor.from(array[3]).toRichText(html));
            } else {
                data.setValue(konvertor.from(array[3]).toString());
            }
            data.setInputType(konvertor.from(array[4]).toString());
            RequirementTreeQueryFormatter.addToMap(konvertor.from(array[0]).toLong(), data, result);
        }
        return result;
    }

    Map<Long, List<ReqLink>> toReqLinkDataMap(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        HashMap result = new HashMap();
        for (Object[] array : tuples) {
            ReqLink data = new ReqLink();
            Boolean direction = konvertor.from(array[1]).toBoolean();
            String role1 = konvertor.from(array[2]).toString();
            String role2 = konvertor.from(array[3]).toString();
            data.setProject(konvertor.from(array[4]).toString());
            data.setReference(konvertor.from(array[5]).toString());
            data.setName(konvertor.from(array[6]).toString());
            data.setVersionNumber(konvertor.from(array[7]).toLong());
            data.setMilestones(konvertor.from(array[8]).toString());
            if (role1.equals(REQLINK_RELATED) || role1.equals(REQLINK_PARENT) || role1.equals(REQLINK_CHILD) || role1.equals(REQLINK_DUPLICATE)) {
                role1 = I18nHelper.translate(role1);
                role2 = I18nHelper.translate(role2);
            }
            if (Boolean.TRUE.equals(direction)) {
                data.setRole(role1);
            } else {
                data.setRole(role2);
            }
            RequirementTreeQueryFormatter.addToMap(konvertor.from(array[0]).toLong(), data, result);
        }
        return result;
    }

    Collection<RequirementVersion> toRequirementVersionData(Collection<Object[]> tuples, List<String> html) {
        Konvertor konvertor = new Konvertor();
        LinkedList<RequirementVersion> result = new LinkedList<RequirementVersion>();
        for (Object[] array : tuples) {
            RequirementVersion version = new RequirementVersion();
            version.setVersionId(konvertor.from(array[0]).toLong());
            version.setReference(konvertor.from(array[1]).toString());
            version.setName(konvertor.from(array[2]).toString());
            version.setVersionNumber(konvertor.from(array[3]).toLong());
            version.setStatus(konvertor.from(array[4]).toString());
            version.setCriticality(konvertor.from(array[5]).toString());
            version.setCategory(konvertor.from(array[6]).toString());
            version.setCategoryType(konvertor.from(array[7]).toString());
            version.setCreatedBy(konvertor.from(array[8]).toString());
            version.setCreatedOn(konvertor.from(array[9]).toDate());
            version.setModifyBy(konvertor.from(array[10]).toString());
            version.setModifyOn(konvertor.from(array[11]).toDate());
            version.setMilestones(konvertor.from(array[12]).toString());
            version.setAttachments(konvertor.from(array[13]).toLong());
            version.setDescription(konvertor.from(array[14]).toRichText(html));
            version.setReqId(konvertor.from(array[15]).toLong());
            result.add(version);
        }
        return result;
    }

    public Map<Long, List<LowReq>> toReqLinkedToHlrDataMap(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        HashMap result = new HashMap();
        for (Object[] array : tuples) {
            LowReq data = new LowReq();
            data.setVersionId(konvertor.from(array[1]).toLong());
            data.setProject(konvertor.from(array[2]).toString());
            data.setReference(konvertor.from(array[3]).toString());
            data.setName(konvertor.from(array[4]).toString());
            data.setMilestones(konvertor.from(array[5]).toString());
            data.setCriticality(konvertor.from(array[6]).toString());
            data.setStatus(konvertor.from(array[7]).toString());
            RequirementTreeQueryFormatter.addToMap(konvertor.from(array[0]).toLong(), data, result);
        }
        return result;
    }

    public void bindReqToProject(Collection<Project> projectDataList, Collection<Requirement> reqDataList) {
        if (!projectDataList.isEmpty()) {
            this.paragraphs = new ArrayList<Integer>();
            this.projectName = Objects.requireNonNull(projectDataList.stream().findFirst().orElse(null)).getProjectName();
            for (Project project : projectDataList) {
                project.setRequirements(this.groupReqForProject(project.getProjectId(), reqDataList));
            }
        }
    }

    private Collection<Requirement> groupReqForProject(Long projectId, Collection<Requirement> requirementCollection) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (Requirement req : requirementCollection) {
            if (!req.getProjectId().equals(projectId)) continue;
            if (!this.projectName.equals(req.getProjectName())) {
                this.paragraphs = new ArrayList<Integer>();
                this.projectName = req.getProjectName();
            }
            this.changeParagraph(req);
            req.setParagraph(this.paragraphs);
            requirements.add(req);
        }
        return requirements;
    }

    private void changeParagraph(Requirement requirement) {
        int level = requirement.getLevel().intValue();
        if (this.paragraphs.isEmpty()) {
            this.paragraphs.add(1);
        } else if (this.paragraphs.size() == level) {
            this.paragraphs.add(1);
        } else {
            int index = this.paragraphs.size();
            while (index > level + 1) {
                this.paragraphs.remove(index - 1);
                --index;
            }
            this.paragraphs.set(level, this.paragraphs.get(level) + 1);
        }
    }

    public void bindVersionsToReq(Collection<Requirement> reqDataList, Collection<RequirementVersion> versionDataList) {
        for (Requirement requirement : reqDataList) {
            requirement.addPreviousVersions(this.groupVersionForReq(requirement, versionDataList));
            requirement.orderVersions();
        }
    }

    private Collection<RequirementVersion> groupVersionForReq(Requirement req, Collection<RequirementVersion> versionDataList) {
        ArrayList<RequirementVersion> versions = new ArrayList<RequirementVersion>();
        for (RequirementVersion version : versionDataList) {
            if (!version.getReqId().equals(req.getReqId())) continue;
            version.setNature(req.isHlr());
            versions.add(version);
        }
        return versions;
    }

    public void bindCufsToVersions(Collection<RequirementVersion> allVersions, Map<Long, List<Cuf>> cufsDataMap) {
        for (RequirementVersion version : allVersions) {
            if (cufsDataMap.get(version.getVersionId()) == null) continue;
            version.getCufs().addAll((Collection<Cuf>)cufsDataMap.get(version.getVersionId()));
        }
    }

    public void bindTcToVersions(Collection<RequirementVersion> allVersions, Map<Long, List<TestCase>> testCasesDataMap) {
        for (RequirementVersion version : allVersions) {
            version.setTestCases(testCasesDataMap.get(version.getVersionId()));
            version.orderTestCases();
        }
    }

    public void bindTcToHLRVersions(Collection<RequirementVersion> allVersions, Map<Long, List<TestCase>> testCasesDataMap) {
        for (RequirementVersion version : allVersions) {
            version.setTestCases(testCasesDataMap.get(version.getVersionId()));
            version.orderTestCases();
        }
    }

    public void bindIndirectTestCaseToAllHighLevelRequirementVersions(Collection<Requirement> requirements, Map<Long, List<TestCase>> testCasesDataMap) {
        for (Requirement requirement : requirements) {
            if (!testCasesDataMap.containsKey(requirement.getReqId())) continue;
            for (RequirementVersion version : requirement.getVersions()) {
                this.bindIndirectTestCaseToHLReqVersion(testCasesDataMap, requirement, version);
            }
        }
    }

    private void bindIndirectTestCaseToHLReqVersion(Map<Long, List<TestCase>> testCasesDataMap, Requirement requirement, RequirementVersion version) {
        List<TestCase> boundTestCasesToHlReq = testCasesDataMap.get(requirement.getReqId());
        if (version.isHasTestCases()) {
            this.addNotLinkedTestCase(boundTestCasesToHlReq, version);
        } else {
            version.setTestCases(boundTestCasesToHlReq);
        }
        version.orderTestCases();
    }

    private void addNotLinkedTestCase(List<TestCase> boundTestCasesToHlReq, RequirementVersion version) {
        for (TestCase tc : boundTestCasesToHlReq) {
            boolean versionAlreadyHasThisTC = version.getTestCases().stream().anyMatch(testCase2 -> Objects.equals(testCase2.getTcId(), tc.getTcId()));
            if (versionAlreadyHasThisTC) continue;
            version.getTestCases().add(tc);
        }
    }

    public void bindAttachReqToReq(Collection<Requirement> requirements, Map<Long, List<AttachReq>> attachReqDataMap) {
        for (Requirement req : requirements) {
            req.setAttachReqs(attachReqDataMap.get(req.getReqId()));
        }
    }

    public void bindReqLinkToVersions(Collection<RequirementVersion> allVersions, Map<Long, List<ReqLink>> reqLinkDataMap) {
        for (RequirementVersion version : allVersions) {
            version.setReqLinks(reqLinkDataMap.get(version.getVersionId()));
        }
    }

    public void bindLowReqToHlr(Collection<Requirement> reqsDataList, Map<Long, List<LowReq>> reqLinkedToHlrDataMap) {
        for (Requirement req : reqsDataList) {
            req.setLowReqs(reqLinkedToHlrDataMap.get(req.getReqId()));
        }
    }

    public Collection<Long> getPreviousVersionIds(Collection<Object[]> tuples) {
        HashSet<Long> previousVersionIds = new HashSet<Long>();
        Konvertor konvertor = new Konvertor();
        for (Object[] array : tuples) {
            previousVersionIds.addAll(konvertor.fromStringToIdList((String)array[1]));
        }
        return previousVersionIds;
    }

    private class Konvertor {
        private Object object;

        private Konvertor() {
        }

        Konvertor from(Object toConvert) {
            this.object = toConvert;
            return this;
        }

        public String toString() {
            if (this.object == null) {
                return "";
            }
            return this.object.toString();
        }

        public String toRichText(List<String> html) {
            if (this.object == null) {
                return "";
            }
            String richText = this.object.toString();
            if (richText.contains("img")) {
                richText = this.findAndReplaceImageHeightWidthValue(richText);
            }
            if (richText.contains("/attachments/download/")) {
                Pattern pattern = Pattern.compile("<img.*?src=([\"'])?(?<src>(?:(?!\\2)[^\"'])+attachments\\/download\\/(?<id>\\d+)([^\"'])?).*?>");
                Matcher matcher = pattern.matcher(richText);
                while (matcher.find()) {
                    String src = matcher.group("src");
                    String id = matcher.group("id");
                    String str = RequirementTreeQueryFormatter.this.attachmentImageHelper.getImageBase64String(Long.valueOf(Long.parseLong(id)));
                    if (str.isBlank()) continue;
                    richText = richText.replace(src, "data:image/png;base64," + str);
                }
            }
            StringBuilder sb = new StringBuilder(richText);
            sb.insert(0, "<html><meta charset='UTF-8'>");
            sb.append("</html>");
            String newVal = "<w:altChunk r:id='reportRichText" + html.size() + "' />";
            html.add(sb.toString());
            return newVal;
        }

        private String findAndReplaceImageHeightWidthValue(String string) {
            String regexPattern = "(?<=\")([0-9]+)(?=\")";
            Pattern pattern = Pattern.compile(regexPattern);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String stringAttribute = matcher.group();
                int intAttribute = Integer.parseInt(stringAttribute);
                intAttribute = Math.min(intAttribute, 700);
                string = string.replace(stringAttribute, Integer.toString(intAttribute));
            }
            return string;
        }

        public Long toLong() {
            if (this.object == null) {
                return null;
            }
            Class<?> clazz = this.object.getClass();
            long result = clazz.equals(String.class) ? Long.parseLong((String)this.object) : (clazz.equals(BigInteger.class) ? ((BigInteger)this.object).longValue() : (clazz.equals(Long.class) ? (Long)this.object : (clazz.equals(Integer.class) ? ((Integer)this.object).longValue() : (clazz.equals(Timestamp.class) ? ((Timestamp)this.object).getTime() : (clazz.equals(Date.class) ? ((Date)this.object).getTime() : Long.parseLong(this.object.toString()))))));
            return result;
        }

        public Boolean toBoolean() {
            if (this.object == null) {
                return false;
            }
            Class<?> clazz = this.object.getClass();
            Boolean result = null;
            if (clazz.equals(String.class)) {
                result = Boolean.valueOf((String)this.object);
            } else if (clazz.equals(Boolean.class)) {
                result = (Boolean)this.object;
            }
            return result;
        }

        public Date toDate() {
            if (this.object instanceof Date) {
                return (Date)this.object;
            }
            return new Date(0L);
        }

        public Collection<Long> fromStringToIdList(String strIds) {
            String strIdsWithoutSeparator = strIds.replace(RequirementTreeQueryFormatter.END_TEXT_SEPARATOR, "");
            HashSet<Long> previousIdList = new HashSet<Long>();
            String[] stringArray = strIdsWithoutSeparator.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String strId = stringArray[n2];
                previousIdList.add(this.from(strId).toLong());
                ++n2;
            }
            return previousIdList;
        }
    }
}

