--
--     This file is part of the Squashtest platform.
--     Copyright (C) Henix, henix.fr
--
--     See the NOTICE file distributed with this work for additional
--     information regarding copyright ownership.
--
--     This is free software: you can redistribute it and/or modify
--     it under the terms of the GNU Lesser General Public License as published by
--     the Free Software Foundation, either version 3 of the License, or
--     (at your option) any later version.
--
--     this software is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU Lesser General Public License for more details.
--
--     You should have received a copy of the GNU Lesser General Public License
--     along with this software.  If not, see <http://www.gnu.org/licenses/>.
--

select distinct TCLN.TCLN_ID,
       R2.RLN_ID,
	   PROJ.NAME as PROJECTNAME,
	   TC.REFERENCE as REFERENCE,
	   TCLN.NAME as TESTCASENAME,
	   GROUP_CONCAT(case when MSTONES.LABEL is not null then concat(MSTONES.LABEL, '=Sep=') end) as MILESTONE,
	   TC.TC_STATUS as STATUS,
	   TC.IMPORTANCE,
	   VERSION.RES_ID
from TEST_CASE_LIBRARY_NODE TCLN
		 inner join TEST_CASE TC on TC.TCLN_ID = TCLN.TCLN_ID
		 inner join PROJECT PROJ on PROJ.PROJECT_ID = TCLN.PROJECT_ID
		 inner join REQUIREMENT_VERSION_COVERAGE VERIF on VERIF.VERIFYING_TEST_CASE_ID = TCLN.TCLN_ID
		 inner join REQUIREMENT_VERSION VERSION on VERSION.RES_ID = VERIF.VERIFIED_REQ_VERSION_ID
    	 inner join REQUIREMENT R on VERSION.RES_ID = R.CURRENT_VERSION_ID
    	 left join REQUIREMENT R2 on R.HIGH_LEVEL_REQUIREMENT_ID = R2.RLN_ID
		 left join MILESTONE_TEST_CASE TCSTONES on TC.TCLN_ID = TCSTONES.TEST_CASE_ID
		 left join MILESTONE MSTONES on TCSTONES.MILESTONE_ID = MSTONES.MILESTONE_ID
where R.HIGH_LEVEL_REQUIREMENT_ID in (:hlrIds)
group by TCLN.TCLN_ID, VERSION.RES_ID, PROJ.NAME, TC.REFERENCE, TCLN.NAME, TC.IMPORTANCE, TC.TCLN_ID, R2.RLN_ID
order by VERSION.RES_ID, TC.IMPORTANCE, PROJ.NAME, TC.REFERENCE, TCLN.NAME
