--
--     This file is part of the Squashtest platform.
--     Copyright (C) Henix, henix.fr
--
--     See the NOTICE file distributed with this work for additional
--     information regarding copyright ownership.
--
--     This is free software: you can redistribute it and/or modify
--     it under the terms of the GNU Lesser General Public License as published by
--     the Free Software Foundation, either version 3 of the License, or
--     (at your option) any later version.
--
--     this software is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU Lesser General Public License for more details.
--
--     You should have received a copy of the GNU Lesser General Public License
--     along with this software.  If not, see <http://www.gnu.org/licenses/>.
--

SELECT
cfv.BOUND_ENTITY_ID as version_id,
cfv.FIELD_TYPE,
cf.LABEL as label,
group_concat(concat(cfvo.label, '=Sep=') order by cfvo.label asc) as value,
cf.INPUT_TYPE as inputType
FROM CUSTOM_FIELD_VALUE cfv
JOIN CUSTOM_FIELD_BINDING cfb ON cfv.CFB_ID = cfb.CFB_ID
JOIN CUSTOM_FIELD cf ON cf.CF_ID = cfb.CF_ID
JOIN CUSTOM_FIELD_VALUE_OPTION cfvo ON cfv.CFV_ID = cfvo.CFV_ID
WHERE cfv.BOUND_ENTITY_TYPE in ('REQUIREMENT_FOLDER', 'REQUIREMENT_VERSION')
AND cfv.BOUND_ENTITY_ID in (:versionIds)
GROUP BY cfv.CFV_ID, cf.CF_ID, cfb.POSITION
order by cfb.POSITION
