/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.api.repository.SqlQueryRunner;

public class RequirementTreeQueryFinder {
    private static final String VERSION_IDS = "versionIds";
    private static final String REQUIREMENT_IDS = "requirementIds";
    private static final String REQUIREMENTS_SORT_ORDER = "requirementsSortOrder";
    private static final String HLR_IDS = "hlrIds";
    private static final String PROJECT_IDS = "projectIds";
    private static final String SQL_FIND_MILESTONE_LABEL = "select label from MILESTONE where milestone_id = :milestoneId";
    private String idsByProjectQuery;
    private String idsBySelectionQuery;
    private String idsByMilestoneQuery;
    private String requirementDataQuery;
    private String previousVersionDataQuery;
    private String boundTCDataQuery;
    private String cufsDataQuery;
    private String attachReqDataQuery;
    private String tagCufsDataQuery;
    private String idsByTagQuery;
    private String reqLinkDataQuery;
    private String allProjects;
    private String projectsByMilestone;
    private String projectsByTags;
    private String projectsBySelection;
    private String reqVersionsIds;
    private String reqLinkedToHlr;
    private String boundTCtoHLRDataQuery;
    private String milestoneConfigurationQuery;
    protected SqlQueryRunner runner;

    RequirementTreeQueryFinder() {
    }

    void setIdsByProjectQuery(String idsByProjectQuery) {
        this.idsByProjectQuery = idsByProjectQuery;
    }

    void setIdsBySelectionQuery(String idsBySelectionQuery) {
        this.idsBySelectionQuery = idsBySelectionQuery;
    }

    public void setIdsByTagQuery(String idsByTagQuery) {
        this.idsByTagQuery = idsByTagQuery;
    }

    void setRequirementDataQuery(String requirementDataQuery) {
        this.requirementDataQuery = requirementDataQuery;
    }

    void setBoundTCDataQuery(String boundTCDataQuery) {
        this.boundTCDataQuery = boundTCDataQuery;
    }

    public void setCufsDataQuery(String cufsDataQuery) {
        this.cufsDataQuery = cufsDataQuery;
    }

    public void setAttachReqDataQuery(String attachReqDataQuery) {
        this.attachReqDataQuery = attachReqDataQuery;
    }

    public void setTagCufsDataQuery(String tagCufsDataQuery) {
        this.tagCufsDataQuery = tagCufsDataQuery;
    }

    public void setReqLinkDataQuery(String reqLinkDataQuery) {
        this.reqLinkDataQuery = reqLinkDataQuery;
    }

    void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    void setIdsByMilestoneQuery(String idsByMilestoneQuery) {
        this.idsByMilestoneQuery = idsByMilestoneQuery;
    }

    public void setAllProjects(String allProjects) {
        this.allProjects = allProjects;
    }

    public void setProjectsByMilestone(String projectsByMilestone) {
        this.projectsByMilestone = projectsByMilestone;
    }

    public void setProjectsByTags(String projectsByTags) {
        this.projectsByTags = projectsByTags;
    }

    public void setProjectsBySelection(String projectsBySelection) {
        this.projectsBySelection = projectsBySelection;
    }

    public void setReqVersionsIds(String reqVersionsIds) {
        this.reqVersionsIds = reqVersionsIds;
    }

    public void setReqLinkedToHlr(String reqLinkedToHlr) {
        this.reqLinkedToHlr = reqLinkedToHlr;
    }

    public void setBoundTCtoHLRDataQuery(String boundTCtoHLRDataQuery) {
        this.boundTCtoHLRDataQuery = boundTCtoHLRDataQuery;
    }

    public void setPreviousVersionDataQuery(String previousVersionDataQuery) {
        this.previousVersionDataQuery = previousVersionDataQuery;
    }

    void setMilestoneConfigurationQuery(String milestoneConfigurationQuery) {
        this.milestoneConfigurationQuery = milestoneConfigurationQuery;
    }

    Collection<Long> findIdsByProject(List<Long> projectIds) {
        if (CollectionUtils.isEmpty(projectIds)) {
            return Collections.emptyList();
        }
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>(1);
        params.put(PROJECT_IDS, projectIds);
        List foundStrIds = this.runner.executeSelect(this.idsByProjectQuery, params);
        return this.toIdList(foundStrIds);
    }

    public Collection<Object[]> findProjects(Collection<String> projectStrIds) {
        Collection<Long> projectIds = this.toIdList(projectStrIds);
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put(PROJECT_IDS, projectIds);
        return this.runner.executeSelect(this.allProjects, params);
    }

    Collection<Long> findIdsBySelection(Collection<String> ids, List<Long> projectIds) {
        LinkedList<Long> versionIds = new LinkedList();
        if (ids != null && !ids.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
            params.put("nodeIds", this.toIdList(ids));
            params.put(PROJECT_IDS, projectIds);
            List foundStrIds = this.runner.executeSelect(this.idsBySelectionQuery, params);
            versionIds.addAll(this.toIdList(foundStrIds));
        } else {
            versionIds = new ArrayList();
        }
        return versionIds;
    }

    public Collection<Object[]> findProjectsBySelection(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
            params.put("nodeIds", this.toIdList(ids));
            return this.runner.executeSelect(this.projectsBySelection, params);
        }
        return Collections.emptyList();
    }

    Collection<Long> findIdsByMilestone(Collection<String> milestoneIds, List<Long> projectIds) {
        if (!milestoneIds.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
            params.put("milestones", this.toIdList(milestoneIds));
            params.put(PROJECT_IDS, projectIds);
            List foundIds = this.runner.executeSelect(this.idsByMilestoneQuery, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    public Collection<Object[]> findProjectsByMilestone(List<String> milestoneIds, List<Long> projectIds) {
        if (!milestoneIds.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
            params.put("milestones", this.toIdList(milestoneIds));
            params.put(PROJECT_IDS, projectIds);
            return this.runner.executeSelect(this.projectsByMilestone, params);
        }
        return Collections.emptyList();
    }

    public Collection<Long> findIdsByTags(List<String> tags, List<Long> projectIds) {
        if (!tags.isEmpty()) {
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
            params.put("tags", tags);
            params.put(PROJECT_IDS, projectIds);
            List foundIds = this.runner.executeSelect(this.idsByTagQuery, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    public Collection<Object[]> findProjectsByTags(List<String> tags, List<Long> projectIds) {
        if (!tags.isEmpty()) {
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
            params.put("tags", tags);
            params.put(PROJECT_IDS, projectIds);
            return this.runner.executeSelect(this.projectsByTags, params);
        }
        return Collections.emptyList();
    }

    Collection<Object[]> getReqDataForRlnIds(Collection<Long> requirementIds, String requirementsSortOrder) {
        return this.execute(this.requirementDataQuery, requirementIds, requirementsSortOrder);
    }

    Collection<Object[]> getVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.reqVersionsIds, REQUIREMENT_IDS, requirementIds);
    }

    Collection<Object[]> getPreviousVersionsData(Collection<Long> previousVersionIds) {
        return this.execute(this.previousVersionDataQuery, "previousVersionIds", previousVersionIds);
    }

    Collection<Object[]> getTestCasesDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.boundTCDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getTestCasesDataForHLR(Collection<Long> nodeIds) {
        return this.execute(this.boundTCtoHLRDataQuery, HLR_IDS, nodeIds);
    }

    Collection<Object[]> getCufsDataForVersionIds(Collection<Long> versionIds) {
        return this.execute(this.cufsDataQuery, VERSION_IDS, versionIds);
    }

    Collection<Object[]> getAttachReqForReqIds(Collection<Long> requirementIds) {
        return this.execute(this.attachReqDataQuery, REQUIREMENT_IDS, requirementIds);
    }

    public Collection<Object[]> getTagCufsDataForVersionIds(Collection<Long> versionIds) {
        return this.execute(this.tagCufsDataQuery, VERSION_IDS, versionIds);
    }

    public Collection<Object[]> getReqLinkDataQueryForVersionIds(Collection<Long> versionIds) {
        return this.execute(this.reqLinkDataQuery, VERSION_IDS, versionIds);
    }

    public Collection<Object[]> getReqLinkedToHlrForHlrIds(Collection<Long> hlrIds) {
        return this.execute(this.reqLinkedToHlr, HLR_IDS, hlrIds);
    }

    String getMilestoneLabel(Integer milestoneId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("milestoneId", milestoneId);
        return (String)this.runner.executeUniqueSelect(SQL_FIND_MILESTONE_LABEL, params);
    }

    Collection<Object[]> getMilestoneConfigurationQuery() {
        return this.runner.executeSelect(this.milestoneConfigurationQuery);
    }

    private Collection<Object[]> execute(String query, String paramName, Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put(paramName, ids);
        return this.runner.executeSelect(query, params);
    }

    private Collection<Object[]> execute(String query, Collection<Long> ids, String requirementsSortOrder) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Collection<Object>> params = new HashMap<String, Collection<Object>>(2);
        params.put(REQUIREMENT_IDS, ids);
        params.put(REQUIREMENTS_SORT_ORDER, Collections.singleton(requirementsSortOrder));
        return this.runner.executeSelect(query, params);
    }

    protected Collection<Long> toIdList(Collection<?> ids) {
        return CollectionUtils.collect(ids, (Transformer)new IdTransformer());
    }

    private static class IdTransformer
    implements Transformer {
        private IdTransformer() {
        }

        public Object transform(Object arg0) {
            String className;
            if (arg0 == null) {
                throw new IllegalArgumentException("ID cannot be null");
            }
            return switch (className = arg0.getClass().getName()) {
                case "java.lang.String" -> Long.valueOf((String)arg0);
                case "java.math.BigInteger" -> ((BigInteger)arg0).longValue();
                case "java.lang.Integer" -> (long)((Integer)arg0).intValue();
                case "java.lang.Long" -> arg0;
                default -> throw new IllegalArgumentException("IdTransformer cannot convert items of class %s".formatted(className));
            };
        }
    }
}

