/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.csp.core.bugtracker.mantis;

import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisConnector;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisExceptionConverter;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerConnector;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerConnectorProvider;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;

@Service
public class MantisConnectorProvider
implements BugTrackerConnectorProvider {
    @Inject
    @Named(value="mantisInterfaceDescriptor")
    private BugTrackerInterfaceDescriptor interfaceDescriptor;
    @Inject
    private MantisExceptionConverter exceptionConverter;

    public String getBugTrackerKind() {
        return "mantis";
    }

    public String getLabel() {
        return "MantisBT connector";
    }

    public BugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullArgumentException("bugTracker");
        }
        MantisConnector connector = new MantisConnector(bugTracker);
        connector.setInterfaceDescriptor(this.interfaceDescriptor);
        connector.setExceptionConverter(this.exceptionConverter);
        return connector;
    }
}

