/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.csp.core.bugtracker.internal.mantis;

import java.rmi.RemoteException;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNotFoundException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;

@Component
public class MantisExceptionConverter {
    @Inject
    @Named(value="mantisConnectorMessageSource")
    private MessageSource messageSource;
    private String remoteWrongCredential = "Access denied";
    private String remoteSummaryRequired = "Mandatory field 'summary'";
    private String remoteDescriptionRequired = "Mandatory field 'description'";
    private String remoteIssueNotFound = "Issue does not exist";

    private Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public BugTrackerRemoteException convertException(RemoteException remoteException) {
        BugTrackerRemoteException exception = this.setIfAccessDenied(remoteException);
        if (exception == null) {
            exception = this.setIfMandatorySummaryNotSet(remoteException);
        }
        if (exception == null) {
            exception = this.setIfMandatoryDescriptionNotSet(remoteException);
        }
        if (exception == null) {
            exception = this.setIssueNotFoundException(remoteException);
        }
        if (exception == null) {
            exception = this.setUnknownException(remoteException);
        }
        return exception;
    }

    public ProjectNotFoundException makeProjectNotFound(String projName) {
        String translation = this.messageSource.getMessage("exception.squash.notfound.project", new Object[]{projName}, this.getLocale());
        return new ProjectNotFoundException(translation, null);
    }

    @PostConstruct
    public void init() {
        Locale locale = Locale.getDefault();
        this.remoteWrongCredential = this.messageSource.getMessage("exception.remote.accessdenied", null, this.remoteWrongCredential, locale);
        this.remoteSummaryRequired = this.messageSource.getMessage("exception.remote.validation.mandatory.summary", null, this.remoteSummaryRequired, locale);
        this.remoteDescriptionRequired = this.messageSource.getMessage("exception.remote.validation.mandatory.description", null, this.remoteDescriptionRequired, locale);
        this.remoteIssueNotFound = this.messageSource.getMessage("exception.remote.notfound.issue", null, this.remoteIssueNotFound, locale);
    }

    private BugTrackerRemoteException setIfAccessDenied(RemoteException remoteException) {
        String message = remoteException.getMessage();
        if (message.equals(this.remoteWrongCredential)) {
            String translation = this.messageSource.getMessage("exception.squash.accessdenied", null, this.getLocale());
            return new BugTrackerNoCredentialsException(translation, (Throwable)remoteException);
        }
        return null;
    }

    private BugTrackerRemoteException setIfMandatorySummaryNotSet(RemoteException remoteException) {
        String message = remoteException.getMessage();
        if (message.contains(this.remoteSummaryRequired)) {
            String translation = this.messageSource.getMessage("exception.squash.validation.mandatory.summary", null, this.getLocale());
            return new BugTrackerRemoteException(translation, (Throwable)remoteException);
        }
        return null;
    }

    private BugTrackerRemoteException setIfMandatoryDescriptionNotSet(RemoteException remoteException) {
        String message = remoteException.getMessage();
        if (message.contains(this.remoteDescriptionRequired)) {
            String translation = this.messageSource.getMessage("exception.squash.validation.mandatory.description", null, this.getLocale());
            return new BugTrackerRemoteException(translation, (Throwable)remoteException);
        }
        return null;
    }

    private BugTrackerRemoteException setIssueNotFoundException(RemoteException remoteException) {
        String message = remoteException.getMessage();
        if (message.contains(this.remoteIssueNotFound)) {
            String translation = this.messageSource.getMessage("exception.squash.notfound.issue", null, this.getLocale());
            return new BugTrackerNotFoundException(translation, (Throwable)remoteException);
        }
        return null;
    }

    public BugTrackerRemoteException newIssueNotFoundException() {
        String translation = this.messageSource.getMessage("exception.squash.notfound.issue", null, this.getLocale());
        return new BugTrackerNotFoundException(translation, null);
    }

    private BugTrackerRemoteException setUnknownException(RemoteException remoteException) {
        String translation = this.messageSource.getMessage("exception.squash.unknownexception", null, this.getLocale());
        return new BugTrackerRemoteException(String.valueOf(translation) + remoteException.getMessage(), (Throwable)remoteException);
    }

    public String getIssueNotFoundMsg() {
        return this.messageSource.getMessage("interface.table.bug-in-error", null, this.getLocale());
    }

    private static interface MantisMessageKeys {
        public static final String WRONG_CREDENTIAL = "exception.remote.accessdenied";
        public static final String MANDATORY_SUMMARY_REQUIRED = "exception.remote.validation.mandatory.summary";
        public static final String MANDATORY_DESCRIPTION_REQUIRED = "exception.remote.validation.mandatory.description";
        public static final String ISSUE_NOT_FOUND = "exception.remote.notfound.issue";
    }

    private static interface SquashMessageKeys {
        public static final String WRONG_CREDENTIAL = "exception.squash.accessdenied";
        public static final String MANDATORY_SUMMARY_REQUIRED = "exception.squash.validation.mandatory.summary";
        public static final String MANDATORY_DESCRIPTION_REQUIRED = "exception.squash.validation.mandatory.description";
        public static final String ISSUE_NOT_FOUND = "exception.squash.notfound.issue";
        public static final String UNKNOWN_EXCEPTION = "exception.squash.unknownexception";
    }
}

