/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.csp.core.bugtracker.internal.mantis;

import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisExceptionConverter;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisStubIssue;
import org.squashtest.csp.core.bugtracker.mantis.binding.AccountData;
import org.squashtest.csp.core.bugtracker.mantis.binding.IssueData;
import org.squashtest.csp.core.bugtracker.mantis.binding.MantisConnectLocator;
import org.squashtest.csp.core.bugtracker.mantis.binding.MantisConnectPortType;
import org.squashtest.csp.core.bugtracker.mantis.binding.ObjectRef;
import org.squashtest.csp.core.bugtracker.mantis.binding.ProjectData;
import org.squashtest.csp.core.bugtracker.mantis.binding.ProjectVersionData;
import org.squashtest.csp.core.bugtracker.net.AuthenticationCredentials;

public class MantisAxis1SoapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantisAxis1SoapClient.class);
    private static final String SOAP_API_LOCATION = "/api/soap/mantisconnect.php";
    private static final String CONFIG_DEFAULT_BUG_SEVERITY = "default_bug_severity";
    private final MantisConnectPortType service;
    private MantisExceptionConverter exceptionConverter;

    public MantisAxis1SoapClient(BugTracker bugTracker) {
        MantisConnectLocator locator = new MantisConnectLocator();
        try {
            this.service = locator.getMantisConnectPort(new URL(String.valueOf(bugTracker.getUrl()) + SOAP_API_LOCATION));
        }
        catch (MalformedURLException e) {
            LOGGER.error("Bug tracker URL is ill-formad :  " + bugTracker.getUrl(), (Throwable)e);
            throw new BugTrackerLocalException((Throwable)e);
        }
        catch (ServiceException e) {
            LOGGER.error("Error while creating SOAP client for " + bugTracker.getUrl(), (Throwable)e);
            throw new BugTrackerRemoteException((Throwable)e);
        }
    }

    public void setMantisExceptionConverter(MantisExceptionConverter converter) {
        this.exceptionConverter = converter;
    }

    public MantisConnectPortType getService() {
        return this.service;
    }

    public ObjectRef[] getSeverities(AuthenticationCredentials credentials) {
        try {
            return this.service.mc_enum_severities(credentials.getUsername(), credentials.getPassword());
        }
        catch (RemoteException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw this.setupException(e);
        }
    }

    public ObjectRef[] getPriorities(AuthenticationCredentials credentials) {
        try {
            return this.service.mc_enum_severities(credentials.getUsername(), credentials.getPassword());
        }
        catch (RemoteException rme) {
            LOGGER.error(rme.getMessage(), (Throwable)rme);
            throw this.setupException(rme);
        }
    }

    public ProjectData[] findProjects(AuthenticationCredentials credentials) {
        try {
            return this.service.mc_projects_get_user_accessible(credentials.getUsername(), credentials.getPassword());
        }
        catch (RemoteException rme) {
            LOGGER.error(rme.getMessage(), (Throwable)rme);
            throw this.setupException(rme);
        }
    }

    public ProjectVersionData[] findVersions(AuthenticationCredentials credentials, BigInteger projectId) {
        try {
            return this.service.mc_project_get_versions(credentials.getUsername(), credentials.getPassword(), projectId);
        }
        catch (RemoteException rme) {
            LOGGER.error(rme.getMessage(), (Throwable)rme);
            throw this.setupException(rme);
        }
    }

    public ObjectRef[] getAccessLevel(AuthenticationCredentials credentials) {
        try {
            return this.service.mc_enum_access_levels(credentials.getUsername(), credentials.getPassword());
        }
        catch (RemoteException rme) {
            LOGGER.error(rme.getMessage(), (Throwable)rme);
            throw this.setupException(rme);
        }
    }

    public AccountData[] findUsersForProject(AuthenticationCredentials credentials, BigInteger projectId, BigInteger access) {
        try {
            return this.service.mc_project_get_users(credentials.getUsername(), credentials.getPassword(), projectId, access);
        }
        catch (RemoteException rme) {
            LOGGER.error(rme.getMessage(), (Throwable)rme);
            throw this.setupException(rme);
        }
    }

    public String[] findCategories(AuthenticationCredentials credentials, BigInteger projectId) {
        try {
            return this.service.mc_project_get_categories(credentials.getUsername(), credentials.getPassword(), projectId);
        }
        catch (RemoteException rme) {
            LOGGER.error(rme.getMessage(), (Throwable)rme);
            throw this.setupException(rme);
        }
    }

    public BigInteger createIssue(AuthenticationCredentials credentials, IssueData issue) {
        try {
            return this.service.mc_issue_add(credentials.getUsername(), credentials.getPassword(), issue);
        }
        catch (RemoteException rme) {
            LOGGER.error(rme.getMessage(), (Throwable)rme);
            throw this.setupException(rme);
        }
    }

    public IssueData getIssue(AuthenticationCredentials credentials, BigInteger issueId) {
        try {
            return this.service.mc_issue_get(credentials.getUsername(), credentials.getPassword(), issueId);
        }
        catch (RemoteException rme) {
            LOGGER.error(rme.getMessage(), (Throwable)rme);
            throw this.setupException(rme);
        }
    }

    public IssueData getIssueOrDeleted(AuthenticationCredentials credentials, BigInteger issueId) {
        try {
            return this.service.mc_issue_get(credentials.getUsername(), credentials.getPassword(), issueId);
        }
        catch (RemoteException rme) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(rme.getMessage(), (Throwable)rme);
            }
            return new MantisStubIssue(issueId, this.exceptionConverter.getIssueNotFoundMsg());
        }
    }

    public String getDefaultPriority(AuthenticationCredentials credentials) {
        return this.getConfig(credentials, CONFIG_DEFAULT_BUG_SEVERITY);
    }

    private String getConfig(AuthenticationCredentials credentials, String configVar) {
        try {
            return this.service.mc_config_get_string(credentials.getUsername(), credentials.getPassword(), configVar);
        }
        catch (RemoteException rme) {
            LOGGER.error(rme.getMessage(), (Throwable)rme);
            throw this.setupException(rme);
        }
    }

    private BugTrackerRemoteException setupException(RemoteException remoteException) {
        return this.exceptionConverter.convertException(remoteException);
    }
}

