/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.csp.core.bugtracker.mantis;

import javax.inject.Inject;
import org.apache.commons.lang.NullArgumentException;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisConnector;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisExceptionConverter;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerConnector;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerConnectorProvider;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;

@Service(value="squashtest.core.bugtracker.mantis.MantisConnectorProvider")
public class MantisConnectorProvider
implements BugTrackerConnectorProvider {
    @Inject
    private BugTrackerInterfaceDescriptor interfaceDescriptor;
    @Inject
    private MantisExceptionConverter exceptionConverter;

    public String getBugTrackerKind() {
        return "mantis";
    }

    public String getLabel() {
        return "MantisBT connector";
    }

    public BugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullArgumentException("bugTracker");
        }
        MantisConnector connector = new MantisConnector(bugTracker);
        connector.setInterfaceDescriptor(this.interfaceDescriptor);
        connector.setExceptionConverter(this.exceptionConverter);
        return connector;
    }
}

