/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.csp.core.bugtracker.internal.mantis;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.squashtest.csp.core.bugtracker.domain.BTIssue;
import org.squashtest.csp.core.bugtracker.domain.BTProject;
import org.squashtest.csp.core.bugtracker.domain.Category;
import org.squashtest.csp.core.bugtracker.domain.Identifiable;
import org.squashtest.csp.core.bugtracker.domain.Permission;
import org.squashtest.csp.core.bugtracker.domain.Priority;
import org.squashtest.csp.core.bugtracker.domain.Severity;
import org.squashtest.csp.core.bugtracker.domain.Status;
import org.squashtest.csp.core.bugtracker.domain.User;
import org.squashtest.csp.core.bugtracker.domain.Version;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisExceptionConverter;
import org.squashtest.csp.core.bugtracker.mantis.binding.AccountData;
import org.squashtest.csp.core.bugtracker.mantis.binding.IssueData;
import org.squashtest.csp.core.bugtracker.mantis.binding.ObjectRef;
import org.squashtest.csp.core.bugtracker.mantis.binding.ProjectData;
import org.squashtest.csp.core.bugtracker.mantis.binding.ProjectVersionData;

public final class MantisEntityConverter {
    private static final BigInteger DELETED_ID = BigInteger.valueOf(-1L);

    private MantisEntityConverter() {
    }

    public static List<Severity> convertSeverities(ObjectRef[] mantisSeverities) {
        ArrayList<Severity> severities = new ArrayList<Severity>(mantisSeverities.length);
        ObjectRef[] objectRefArray = mantisSeverities;
        int n = mantisSeverities.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectRef ms = objectRefArray[n2];
            String id = MantisEntityConverter.mantis2SquashId(ms.getId());
            String name = ms.getName();
            severities.add(new Severity(id, name));
            ++n2;
        }
        return severities;
    }

    public static List<Priority> mantis2SquashPriority(ObjectRef[] mantisSeverities) {
        LinkedList<Priority> priorities = new LinkedList<Priority>();
        ObjectRef[] objectRefArray = mantisSeverities;
        int n = mantisSeverities.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectRef mp = objectRefArray[n2];
            String id = MantisEntityConverter.mantis2SquashId(mp.getId());
            String name = mp.getName();
            priorities.add(new Priority(id, name));
            ++n2;
        }
        return priorities;
    }

    public static List<BTProject> mantis2SquashProject(ProjectData[] mantisProjects) {
        if (mantisProjects == null || mantisProjects.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<BTProject> projects = new LinkedList<BTProject>();
        ProjectData[] projectDataArray = mantisProjects;
        int n = mantisProjects.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectData mpd = projectDataArray[n2];
            String id = MantisEntityConverter.mantis2SquashId(mpd.getId());
            String name = mpd.getName();
            projects.add(new BTProject(id, name));
            projects.addAll(MantisEntityConverter.mantis2SquashProject(mpd.getSubprojects()));
            ++n2;
        }
        return projects;
    }

    public static BTProject mantis2SquashSingleProject(ObjectRef data) {
        return new BTProject(MantisEntityConverter.mantis2SquashId(data.getId()), data.getName());
    }

    public static Priority mantis2SquashPriority(ObjectRef data) {
        return new Priority(MantisEntityConverter.mantis2SquashId(data.getId()), data.getName());
    }

    public static Status mantis2SquashStatus(ObjectRef mantisStatus) {
        if (mantisStatus == null) {
            return Status.NO_STATUS;
        }
        return new Status(MantisEntityConverter.mantis2SquashId(mantisStatus.getId()), mantisStatus.getName());
    }

    public static List<Version> mantis2SquashVersion(ProjectVersionData[] mantisVersions) {
        LinkedList<Version> versions = new LinkedList<Version>();
        if (mantisVersions == null || mantisVersions.length == 0) {
            versions.add(Version.NO_VERSION);
        } else {
            ProjectVersionData[] projectVersionDataArray = mantisVersions;
            int n = mantisVersions.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectVersionData pvd = projectVersionDataArray[n2];
                String id = MantisEntityConverter.mantis2SquashId(pvd.getId());
                String name = pvd.getName();
                versions.add(new Version(id, name));
                ++n2;
            }
        }
        return versions;
    }

    public static List<Category> mantis2SquashCategory(String[] mantisCategories) {
        LinkedList<Category> categories = new LinkedList<Category>();
        long dummyId = 0L;
        if (mantisCategories == null || mantisCategories.length == 0) {
            categories.add(Category.NO_CATEGORY);
        } else {
            String[] stringArray = mantisCategories;
            int n = mantisCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                String id = Long.valueOf(dummyId++).toString();
                String name = category;
                categories.add(new Category(id, name));
                ++n2;
            }
        }
        return categories;
    }

    public static List<Permission> mantis2SquashPermission(ObjectRef[] mantisPermissions) {
        LinkedList<Permission> accessLevels = new LinkedList<Permission>();
        ObjectRef[] objectRefArray = mantisPermissions;
        int n = mantisPermissions.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectRef level = objectRefArray[n2];
            String id = MantisEntityConverter.mantis2SquashId(level.getId());
            String name = level.getName();
            accessLevels.add(new Permission(id, name));
            ++n2;
        }
        return accessLevels;
    }

    public static List<User> mantis2SquashUser(AccountData[] mantisUsers) {
        LinkedList<User> users = new LinkedList<User>();
        AccountData[] accountDataArray = mantisUsers;
        int n = mantisUsers.length;
        int n2 = 0;
        while (n2 < n) {
            AccountData muser = accountDataArray[n2];
            String id = MantisEntityConverter.mantis2SquashId(muser.getId());
            String name = muser.getName();
            users.add(new User(id, name));
            ++n2;
        }
        return users;
    }

    public static User mantis2SquashSingleUser(AccountData data) {
        return new User(MantisEntityConverter.mantis2SquashId(data.getId()), data.getName());
    }

    public static AccountData squash2MantisUser(User squashUser) {
        AccountData data = new AccountData();
        data.setId(MantisEntityConverter.squash2MantisId(squashUser.getId()));
        data.setName(squashUser.getName());
        return data;
    }

    public static BigInteger squash2MantisId(String squashId) {
        return BigInteger.valueOf(Long.parseLong(squashId));
    }

    public static String mantis2SquashId(BigInteger mantisId) {
        return mantisId.toString();
    }

    public static IssueData squashToMantisIssue(BTIssue squashIssue) {
        IssueData data = new IssueData();
        data.setProject(MantisEntityConverter.makeObjectRef(squashIssue.getProject()));
        data.setSeverity(MantisEntityConverter.makeObjectRef(squashIssue.getPriority()));
        Version sqVersion = squashIssue.getVersion();
        if (sqVersion.isDummy()) {
            data.setVersion(null);
        } else {
            data.setVersion(sqVersion.getName());
        }
        Category sqCategory = squashIssue.getCategory();
        if (sqCategory.isDummy()) {
            data.setCategory(null);
        } else {
            data.setCategory(sqCategory.getName());
        }
        AccountData assignee = MantisEntityConverter.squash2MantisUser(squashIssue.getAssignee());
        data.setHandler(assignee);
        data.setSummary(squashIssue.getSummary());
        data.setDescription(squashIssue.getDescription());
        data.setAdditional_information(squashIssue.getComment());
        return data;
    }

    public static BTIssue mantis2squashIssue(IssueData mantisIssue) {
        BTIssue issue = new BTIssue();
        issue.setId(MantisEntityConverter.mantis2SquashId(mantisIssue.getId()));
        issue.setSummary(mantisIssue.getSummary());
        issue.setProject(MantisEntityConverter.mantis2SquashSingleProject(mantisIssue.getProject()));
        if (!mantisIssue.getProject().getId().equals(DELETED_ID)) {
            issue.setPriority(MantisEntityConverter.mantis2SquashPriority(mantisIssue.getSeverity()));
            issue.setVersion(mantisIssue.getVersion() != null ? new Version(null, mantisIssue.getVersion()) : Version.NO_VERSION);
            issue.setReporter(MantisEntityConverter.mantis2SquashSingleUser(mantisIssue.getReporter()));
            issue.setCategory(mantisIssue.getCategory() != null ? new Category(null, mantisIssue.getCategory()) : Category.NO_CATEGORY);
            issue.setAssignee(mantisIssue.getHandler() != null ? MantisEntityConverter.mantis2SquashSingleUser(mantisIssue.getHandler()) : User.NO_USER);
            issue.setDescription(mantisIssue.getDescription());
            issue.setComment(mantisIssue.getAdditional_information() != null ? mantisIssue.getAdditional_information() : "");
            issue.setCreatedOn(mantisIssue.getDate_submitted().getTime());
            issue.setStatus(MantisEntityConverter.mantis2SquashStatus(mantisIssue.getStatus()));
        }
        return issue;
    }

    public static BTIssue issueNotFound(String issueKey, MantisExceptionConverter conv) {
        BTIssue issue = new BTIssue();
        issue.setId(issueKey);
        issue.setSummary(conv.getIssueNotFoundMsg());
        issue.setProject(new BTProject("", ""));
        return issue;
    }

    private static ObjectRef makeObjectRef(Identifiable<?> squashEntity) {
        if (!squashEntity.isDummy()) {
            ObjectRef oRef = new ObjectRef();
            oRef.setId(MantisEntityConverter.squash2MantisId(squashEntity.getId()));
            oRef.setName(squashEntity.getName());
            return oRef;
        }
        return null;
    }
}

