/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.csp.core.bugtracker.internal.mantis;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNotFoundException;
import org.squashtest.csp.core.bugtracker.domain.BTIssue;
import org.squashtest.csp.core.bugtracker.domain.BTProject;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.domain.Category;
import org.squashtest.csp.core.bugtracker.domain.Identifiable;
import org.squashtest.csp.core.bugtracker.domain.Permission;
import org.squashtest.csp.core.bugtracker.domain.Priority;
import org.squashtest.csp.core.bugtracker.domain.User;
import org.squashtest.csp.core.bugtracker.domain.Version;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisAxis1SoapClient;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisEntityConverter;
import org.squashtest.csp.core.bugtracker.internal.mantis.MantisExceptionConverter;
import org.squashtest.csp.core.bugtracker.mantis.binding.AccountData;
import org.squashtest.csp.core.bugtracker.mantis.binding.IssueData;
import org.squashtest.csp.core.bugtracker.mantis.binding.ObjectRef;
import org.squashtest.csp.core.bugtracker.mantis.binding.ProjectData;
import org.squashtest.csp.core.bugtracker.mantis.binding.ProjectVersionData;
import org.squashtest.csp.core.bugtracker.net.AuthenticationCredentials;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerConnector;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;

public class MantisConnector
implements BugTrackerConnector {
    private static final String MANTIS_ISSUE_SUFFIX = "/view.php";
    private final ThreadLocal<AuthenticationCredentials> credentialsHolder = new ThreadLocal();
    private final MantisAxis1SoapClient client;
    private MantisExceptionConverter exConverter;
    private BugTrackerInterfaceDescriptor interfaceDescriptor;

    public MantisConnector(BugTracker bugTracker) {
        this.client = new MantisAxis1SoapClient(bugTracker);
    }

    public void setInterfaceDescriptor(BugTrackerInterfaceDescriptor interfaceDescriptor) {
        this.interfaceDescriptor = interfaceDescriptor;
    }

    public void setExceptionConverter(MantisExceptionConverter converter) {
        this.exConverter = converter;
        this.client.setMantisExceptionConverter(converter);
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        return this.interfaceDescriptor;
    }

    public void authenticate(AuthenticationCredentials credentials) {
        if (credentials == null) {
            throw new NullArgumentException("credentials");
        }
        this.credentialsHolder.set(credentials);
    }

    public String makeViewIssueUrlSuffix(String issueId) {
        return "/view.php?id=" + issueId;
    }

    public void checkCredentials(AuthenticationCredentials credentials) {
        this.client.getSeverities(credentials);
    }

    public List<Priority> getPriorities() {
        ObjectRef[] priorities = this.client.getPriorities(this.credentialsHolder.get());
        return MantisEntityConverter.mantis2SquashPriority(priorities);
    }

    public List<Permission> getPermissions() {
        ObjectRef[] accessLevels = this.client.getAccessLevel(this.credentialsHolder.get());
        return MantisEntityConverter.mantis2SquashPermission(accessLevels);
    }

    public BTProject findProject(String projectName) {
        ProjectData[] mantisProjects = this.client.findProjects(this.credentialsHolder.get());
        List<BTProject> projects = MantisEntityConverter.mantis2SquashProject(mantisProjects);
        BTProject found = this.findInListByName(projects, projectName);
        if (found != null) {
            return this.populateProject(found);
        }
        throw this.exConverter.makeProjectNotFound(projectName);
    }

    public BTProject findProjectById(String projectId) {
        ProjectData[] mantisProjects = this.client.findProjects(this.credentialsHolder.get());
        List<BTProject> projects = MantisEntityConverter.mantis2SquashProject(mantisProjects);
        BTProject found = this.findInListById(projects, projectId);
        if (found != null) {
            return this.populateProject(found);
        }
        throw this.exConverter.makeProjectNotFound(projectId);
    }

    public List<Version> findVersions(String projectName) {
        BTProject project = this.findProject(projectName);
        return this.findVersionsById(project.getId());
    }

    public List<Version> findVersionsById(String projectId) {
        ProjectVersionData[] mantisVersions = this.client.findVersions(this.credentialsHolder.get(), MantisEntityConverter.squash2MantisId(projectId));
        return MantisEntityConverter.mantis2SquashVersion(mantisVersions);
    }

    public List<Version> findVersions(BTProject project) {
        return this.findVersionsById(project.getId());
    }

    public List<User> findUsers(String projectName) {
        BTProject project = this.findProject(projectName);
        List<Permission> permissions = this.getPermissions();
        return this.makeUserList(project.getId(), permissions);
    }

    public List<User> findUsersById(String projectID) {
        List<Permission> permissions = this.getPermissions();
        return this.makeUserList(projectID, permissions);
    }

    public List<User> findUsers(BTProject project) {
        List<Permission> permissions = this.getPermissions();
        return this.makeUserList(project.getId(), permissions);
    }

    public List<Category> findCategories(BTProject project) {
        String[] categories = this.client.findCategories(this.credentialsHolder.get(), MantisEntityConverter.squash2MantisId(project.getId()));
        return MantisEntityConverter.mantis2SquashCategory(categories);
    }

    public BTIssue createIssue(BTIssue issue) {
        IssueData data = MantisEntityConverter.squashToMantisIssue(issue);
        BigInteger issueId = this.client.createIssue(this.credentialsHolder.get(), data);
        issue.setId(MantisEntityConverter.mantis2SquashId(issueId));
        return issue;
    }

    public BTIssue findIssue(String key) {
        BigInteger remoteId = null;
        try {
            remoteId = MantisEntityConverter.squash2MantisId(key);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.exConverter.newIssueNotFoundException();
        }
        IssueData mantisIssue = this.client.getIssue(this.credentialsHolder.get(), remoteId);
        BTIssue issue = MantisEntityConverter.mantis2squashIssue(mantisIssue);
        BTProject project = this.findProject(issue.getProject().getName());
        issue.setVersion((Version)this.findInListByName(project.getVersions(), issue.getVersion().getName()));
        issue.setCategory((Category)this.findInListByName(project.getCategories(), issue.getCategory().getName()));
        issue.setAssignee((User)this.findInListByName(project.getUsers(), issue.getAssignee().getName()));
        issue.setProject(project);
        return issue;
    }

    public List<BTIssue> findIssues(List<String> issueKeyList) {
        ArrayList<BTIssue> toReturn = new ArrayList<BTIssue>();
        for (String issueKey : issueKeyList) {
            try {
                IssueData mantisIssue = this.client.getIssue(this.credentialsHolder.get(), MantisEntityConverter.squash2MantisId(issueKey));
                BTIssue issue = MantisEntityConverter.mantis2squashIssue(mantisIssue);
                toReturn.add(issue);
            }
            catch (BugTrackerNotFoundException bugTrackerNotFoundException) {
                toReturn.add(MantisEntityConverter.issueNotFound(issueKey, this.exConverter));
            }
        }
        return toReturn;
    }

    private BTProject populateProject(BTProject project) {
        project.addAllVersions(this.findVersions(project));
        project.addAllUsers(this.findUsers(project));
        project.addAllCategories(this.findCategories(project));
        project.addallPriorities(this.getPriorities());
        project.setDefaultIssuePriority(this.getDefaultPriority(project.getPriorities()));
        return project;
    }

    private Priority getDefaultPriority(List<Priority> projectPriorities) {
        String defaultPriorityId = this.client.getDefaultPriority(this.credentialsHolder.get());
        return this.findInListById(projectPriorities, defaultPriorityId);
    }

    private List<User> makeUserList(String projectId, List<Permission> permissions) {
        HashMap<String, User> userMap = new HashMap<String, User>();
        for (Permission permission : permissions) {
            AccountData[] mantisUsers = this.client.findUsersForProject(this.credentialsHolder.get(), MantisEntityConverter.squash2MantisId(projectId), MantisEntityConverter.squash2MantisId(permission.getId()));
            List<User> subList = MantisEntityConverter.mantis2SquashUser(mantisUsers);
            for (User user : subList) {
                if (userMap.get(user.getId()) == null) {
                    userMap.put(user.getId(), user);
                }
                ((User)userMap.get(user.getId())).addPermission(permission);
            }
        }
        return new LinkedList<User>(userMap.values());
    }

    private <X extends Identifiable> X findInListByName(List<X> identifiables, String name) {
        for (Identifiable identifiable : identifiables) {
            if (!identifiable.getName().equals(name)) continue;
            return (X)identifiable;
        }
        return null;
    }

    private <X extends Identifiable> X findInListById(List<X> identifiables, String id) {
        for (Identifiable identifiable : identifiables) {
            if (!identifiable.getId().equals(id)) continue;
            return (X)identifiable;
        }
        return null;
    }
}

