/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.csp.core.bugtracker.internal.mantis;

import java.util.Locale;
import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;

@Component(value="squashtest.core.bugtracker.BugTrackerInterfaceDescriptor")
public class MantisInterfaceDescriptor
implements BugTrackerInterfaceDescriptor {
    private static final String REPORT_PRIORITY_LABEL = "interface.report.priority.label";
    private static final String REPORT_VERSION_LABEL = "interface.report.version.label";
    private static final String REPORT_ASSIGNEE_LABEL = "interface.report.assignee.label";
    private static final String REPORT_CATEGORY_LABEL = "interface.report.category.label";
    private static final String REPORT_SUMMARY_LABEL = "interface.report.summary.label";
    private static final String REPORT_DESCRIPTION_LABEL = "interface.report.description.label";
    private static final String REPORT_COMMENT_LABEL = "interface.report.comment.label";
    private static final String REPORT_EMPTY_VERSION = "interface.report.lists.emptyversion.label";
    private static final String REPORT_EMPTY_CATEGORY = "interface.report.lists.emptycategory.label";
    private static final String REPORT_EMPTY_ASSIGNEE = "interface.report.lists.emptyassignee.label";
    private static final String TABLE_ID_HEADER = "interface.table.issueid.header";
    private static final String TABLE_SUMMARY_HEADER = "interface.table.summary.header";
    private static final String TABLE_PRIORITY_HEADER = "interface.table.priority.header";
    private static final String TABLE_STATUS_HEADER = "interface.table.status.header";
    private static final String TABLE_ASSIGNEE_HEADER = "interface.table.assignee.header";
    private static final String TABLE_REPORTEDIN_HEADER = "interface.table.reportedin.header";
    private static final String TABLE_DESCRIPTION_HEADER = "interface.table.description.header";
    private static final String TABLE_EMPTY_ASSIGNEE = "interface.table.null.assignee.label";
    private final ThreadLocal<Locale> threadLocalLocale = new ThreadLocal();
    @Inject
    private MessageSource messageSource;

    public MantisInterfaceDescriptor() {
        this.threadLocalLocale.set(LocaleContextHolder.getLocale());
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setLocale(Locale locale) {
        this.threadLocalLocale.set(locale);
    }

    public boolean getSupportsRichDescription() {
        return false;
    }

    public boolean getSupportsRichComment() {
        return false;
    }

    public String getReportPriorityLabel() {
        return this.getValue(REPORT_PRIORITY_LABEL);
    }

    public String getReportVersionLabel() {
        return this.getValue(REPORT_VERSION_LABEL);
    }

    public String getReportAssigneeLabel() {
        return this.getValue(REPORT_ASSIGNEE_LABEL);
    }

    public String getReportCategoryLabel() {
        return this.getValue(REPORT_CATEGORY_LABEL);
    }

    public String getReportSummaryLabel() {
        return this.getValue(REPORT_SUMMARY_LABEL);
    }

    public String getReportDescriptionLabel() {
        return this.getValue(REPORT_DESCRIPTION_LABEL);
    }

    public String getReportCommentLabel() {
        return this.getValue(REPORT_COMMENT_LABEL);
    }

    public String getEmptyVersionListLabel() {
        return this.getValue(REPORT_EMPTY_VERSION);
    }

    public String getEmptyCategoryListLabel() {
        return this.getValue(REPORT_EMPTY_CATEGORY);
    }

    public String getEmptyAssigneeListLabel() {
        return this.getValue(REPORT_EMPTY_ASSIGNEE);
    }

    public String getTableIssueIDHeader() {
        return this.getValue(TABLE_ID_HEADER);
    }

    public String getTableSummaryHeader() {
        return this.getValue(TABLE_SUMMARY_HEADER);
    }

    public String getTablePriorityHeader() {
        return this.getValue(TABLE_PRIORITY_HEADER);
    }

    public String getTableStatusHeader() {
        return this.getValue(TABLE_STATUS_HEADER);
    }

    public String getTableAssigneeHeader() {
        return this.getValue(TABLE_ASSIGNEE_HEADER);
    }

    public String getTableReportedInHeader() {
        return this.getValue(TABLE_REPORTEDIN_HEADER);
    }

    public String getTableDescriptionHeader() {
        return this.getValue(TABLE_DESCRIPTION_HEADER);
    }

    public String getTableNoAssigneeLabel() {
        return this.getValue(TABLE_EMPTY_ASSIGNEE);
    }

    private String getValue(String key) {
        return this.messageSource.getMessage(key, null, this.threadLocalLocale.get());
    }
}

