/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder.markdown;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.squashtest.it.datasetbuilder.apibuilder.Attribute;
import org.squashtest.it.datasetbuilder.apibuilder.Entity;

public class MarkdownDocumentationGenerator {
    private final List<Entity> entityTypes;
    private final String basedir;

    public MarkdownDocumentationGenerator(List<Entity> entityTypes, String basedir) {
        this.entityTypes = entityTypes;
        this.basedir = basedir;
    }

    public String generateDocumentation() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream templateInputStream = this.getClass().getResourceAsStream("/doc-template.md");){
            Objects.requireNonNull(templateInputStream);
            String template = new String(templateInputStream.readAllBytes());
            String example = Files.readString(Path.of(this.basedir, "../example.yaml"));
            List<Entity> sortedEntities = this.entityTypes.stream().filter(entity -> !entity.isRoot()).sorted(Comparator.comparing(Entity::name)).toList();
            template = template.replace("{{generated_on}}", MarkdownDocumentationGenerator.getGeneratedOn());
            template = template.replace("{{entities_toc}}", MarkdownDocumentationGenerator.getEntitiesTableOfContents(sortedEntities));
            template = template.replace("{{entities}}", MarkdownDocumentationGenerator.getEntities(sortedEntities));
            return template = template.replace("{{example}}", example);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String getGeneratedOn() {
        return "Documentation generated on " + String.valueOf(LocalDateTime.now());
    }

    private static String getEntitiesTableOfContents(List<Entity> sortedEntities) {
        StringBuilder entitiesTOC = new StringBuilder();
        for (Entity entity : sortedEntities) {
            String link = entity.name().toLowerCase().replace(" ", "-");
            if (entity.isAbstract()) {
                entitiesTOC.append(String.format("  - [%s (abstract)](#%s)%n", entity.name(), link + "-abstract"));
                continue;
            }
            entitiesTOC.append(String.format("  - [%s](#%s)%n", entity.name(), link));
        }
        return entitiesTOC.toString();
    }

    private static String getEntities(List<Entity> sortedEntities) {
        StringBuilder result = new StringBuilder();
        for (Entity entity : sortedEntities) {
            result.append("### ").append(entity.name());
            if (entity.isAbstract()) {
                result.append(" (abstract)");
            }
            result.append("\n\n");
            result.append("| Name | Type | Default value |\n");
            result.append("|------|------|---------------|\n");
            for (Attribute attribute : entity.attributes()) {
                String defaultValue = attribute.defaultValue() != null ? attribute.defaultValue().getMarkdownDescription() : "-";
                Object type = attribute.type().getMarkdownType();
                if (attribute.isMany()) {
                    type = (String)type + "[]";
                }
                result.append(String.format("| %s | %s | %s |%n", attribute.name(), type, defaultValue));
            }
            result.append("\n");
        }
        return result.toString();
    }

    public static boolean documentationHasChanged(String documentation, Path pathToDocumentation) throws IOException {
        String newDocumentation;
        if (!Files.exists(pathToDocumentation, new LinkOption[0])) {
            return true;
        }
        String existingDocumentation = MarkdownDocumentationGenerator.removeGeneratedDate(Files.readString(pathToDocumentation));
        return !existingDocumentation.equals(newDocumentation = MarkdownDocumentationGenerator.removeGeneratedDate(documentation));
    }

    private static String removeGeneratedDate(String document) {
        String[] lines = document.replace("\r\n", "\n").replace("\r", "\n").trim().split("\n");
        StringBuilder sb = new StringBuilder();
        int i = 3;
        while (i < lines.length) {
            sb.append(lines[i]).append("\n");
            ++i;
        }
        return sb.toString();
    }
}

