/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder;

import org.squashtest.it.datasetbuilder.apibuilder.Cardinality;

public final class Validation {
    private Validation() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static void validateName(String name) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (Validation.containsWhitespace(name)) {
            throw new IllegalArgumentException("Name cannot contain whitespace: " + name);
        }
    }

    public static boolean containsWhitespace(String name) {
        return name.chars().anyMatch(Character::isWhitespace);
    }

    public static void validateCardinality(Cardinality cardinality) {
        if (cardinality.min().value() < 0) {
            throw new IllegalArgumentException("Cardinality minimum must be greater than or equal to 0");
        }
        if (!cardinality.max().isInfinite() && cardinality.max().value() < 0) {
            throw new IllegalArgumentException("Cardinality maximum must be greater than or equal to 0");
        }
        if (cardinality.min().isInfinite() && cardinality.max().isFinite()) {
            throw new IllegalArgumentException("Cardinality minimum cannot be infinite while maximum is finite");
        }
        if (cardinality.min().isInfinite() && cardinality.max().isInfinite()) {
            return;
        }
        if (cardinality.max().isZero()) {
            throw new IllegalArgumentException("Cardinality maximum cannot be zero");
        }
        if (cardinality.min().value() > cardinality.max().value()) {
            throw new IllegalArgumentException("Cardinality minimum must be less than or equal to maximum");
        }
    }
}

