/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder;

import java.util.Arrays;
import java.util.List;

public final class EnumParser {
    private EnumParser() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static Class<?> getEnumClass(String enumClassName) {
        try {
            Class<?> clazz = Class.forName(enumClassName);
            if (!Enum.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class is not an enum: " + enumClassName);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown enum class: " + enumClassName, e);
        }
    }

    public static List<String> getEnumConstants(String enumClassName) {
        Class<?> clazz = EnumParser.getEnumClass(enumClassName);
        return Arrays.stream(clazz.getEnumConstants()).map(Object::toString).toList();
    }

    public static <E extends Enum<E>> E parseEnum(String enumClassName, String enumValueName) {
        Class<Enum> enumClass = EnumParser.getEnumClass(enumClassName).asSubclass(Enum.class).asSubclass(Enum.class);
        return (E)Enum.valueOf(enumClass, enumValueName);
    }
}

