/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.squashtest.it.datasetbuilder.apibuilder.Entity;
import org.squashtest.it.datasetbuilder.apibuilder.java.JavaModelGenerator;
import org.squashtest.it.datasetbuilder.apibuilder.json.JsonSchemaGenerator;
import org.squashtest.it.datasetbuilder.apibuilder.markdown.MarkdownDocumentationGenerator;
import org.squashtest.it.datasetbuilder.apibuilder.parser.ModelDescriptorParser;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static final String PACKAGE_NAME = "org.squashtest.it.datasetbuilder.api.model";
    private static final String SCHEMA_JSON_FILENAME = "schema.json";
    private static final String DOCUMENTATION_FILENAME = "documentation.md";

    public static void main(String[] args) throws IOException, URISyntaxException {
        ClassLoader classLoader = Main.class.getClassLoader();
        URL resourceUrl = classLoader.getResource("Model.txt");
        Objects.requireNonNull(resourceUrl, "Model.txt not found");
        Path modelPath = Paths.get(resourceUrl.toURI());
        String document = Files.readString(modelPath);
        List<Entity> entities = ModelDescriptorParser.parse(document);
        JsonSchemaGenerator generator = new JsonSchemaGenerator(entities);
        String schema = generator.generateSchema();
        String basedir = System.getProperty("basedir");
        Path outputPath = Path.of(basedir, new String[0]).getParent();
        Files.writeString(outputPath.resolve(SCHEMA_JSON_FILENAME), (CharSequence)schema, new OpenOption[0]);
        MarkdownDocumentationGenerator docGenerator = new MarkdownDocumentationGenerator(entities, basedir);
        String documentation = docGenerator.generateDocumentation();
        Path documentationPath = outputPath.resolve(DOCUMENTATION_FILENAME);
        if (MarkdownDocumentationGenerator.documentationHasChanged(documentation, documentationPath)) {
            LOGGER.info("Documentation has changed, updating...", new Object[0]);
            Files.writeString(documentationPath, (CharSequence)documentation, new OpenOption[0]);
        } else {
            LOGGER.info("Documentation is already up to date.", new Object[0]);
        }
        Path generatedJavaPath = modelPath.getParent().getParent().resolve("generated-sources/java/");
        JavaModelGenerator javaGenerator = new JavaModelGenerator(entities, PACKAGE_NAME, generatedJavaPath.toString());
        javaGenerator.generateModels();
    }
}

