/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.squashtest.it.datasetbuilder.apibuilder.Attribute;
import org.squashtest.it.datasetbuilder.apibuilder.Cardinality;
import org.squashtest.it.datasetbuilder.apibuilder.CardinalityBound;
import org.squashtest.it.datasetbuilder.apibuilder.DefaultValue;
import org.squashtest.it.datasetbuilder.apibuilder.Entity;
import org.squashtest.it.datasetbuilder.apibuilder.ModelType;
import org.squashtest.it.datasetbuilder.apibuilder.ValuePlaceholder;

public final class ModelDescriptorParser {
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("^-\\s*(\\w+)\\s*:\\s*([\\w\\[\\]*().]+)(?:\\s*=\\s*(.+))?");

    private ModelDescriptorParser() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static List<Entity> parse(String document) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Entity lastType = null;
        String[] stringArray = document.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.isBlank() && !line.startsWith("#")) {
                if (line.startsWith("- ")) {
                    if (lastType == null) {
                        throw new IllegalStateException("Attribute found before type declaration");
                    }
                    ModelDescriptorParser.parseAttribute(line, lastType);
                } else {
                    if (lastType != null) {
                        entities.add(lastType);
                    }
                    lastType = ModelDescriptorParser.parseEntity(line);
                }
            }
            ++n2;
        }
        if (lastType != null) {
            entities.add(lastType);
        }
        return entities;
    }

    private static CardinalityBound parseCardinalityBound(String input) {
        if ("*".equals(input)) {
            return new CardinalityBound(0, true);
        }
        return new CardinalityBound(Integer.parseInt(input), false);
    }

    private static Cardinality parseCardinality(String input) {
        if (input.contains("..")) {
            String[] parts = input.split("\\.\\.");
            CardinalityBound min = ModelDescriptorParser.parseCardinalityBound(parts[0]);
            CardinalityBound max = ModelDescriptorParser.parseCardinalityBound(parts[1]);
            return new Cardinality(min, max);
        }
        CardinalityBound bound = ModelDescriptorParser.parseCardinalityBound(input);
        return new Cardinality(bound, bound);
    }

    private static DefaultValue parseDefaultValue(ModelType.Kind type, String rawValue) {
        if (ValuePlaceholder.isPlaceholder(rawValue)) {
            return DefaultValue.ofPlaceholder(rawValue);
        }
        return switch (type) {
            case ModelType.Kind.STRING -> DefaultValue.ofString(rawValue);
            case ModelType.Kind.BOOLEAN -> DefaultValue.ofBoolean(rawValue);
            case ModelType.Kind.LONG -> DefaultValue.ofLong(rawValue);
            case ModelType.Kind.INT -> DefaultValue.ofInt(rawValue);
            case ModelType.Kind.ENUM -> DefaultValue.ofEnum(rawValue);
            default -> throw new IllegalArgumentException("Unsupported default value: " + rawValue);
        };
    }

    private static void parseAttribute(String line, Entity lastType) {
        Cardinality cardinality;
        Matcher attributMatcher = ATTRIBUTE_PATTERN.matcher(line);
        if (!attributMatcher.find()) {
            throw new IllegalArgumentException("Invalid attribute: " + line);
        }
        String name = attributMatcher.group(1);
        ModelDescriptorParser.checkAttributeName(name);
        String type = attributMatcher.group(2);
        String rawDefaultValue = attributMatcher.group(3);
        ModelType modelType = ModelType.fromModel(type);
        DefaultValue defaultValue = null;
        if (rawDefaultValue != null) {
            defaultValue = ModelDescriptorParser.parseDefaultValue(modelType.getKind(), rawDefaultValue);
        }
        if (modelType.getTypeCardinality() != null) {
            cardinality = ModelDescriptorParser.parseCardinality(modelType.getTypeCardinality());
        } else {
            boolean isOptional = rawDefaultValue != null && defaultValue == null;
            cardinality = new Cardinality(CardinalityBound.of(isOptional ? 0 : 1), CardinalityBound.of(1));
        }
        Attribute attribute = new Attribute(name, modelType, cardinality, defaultValue);
        lastType.attributes().add(attribute);
    }

    private static Entity parseEntity(String line) {
        String type;
        String input = line.trim();
        String superType = null;
        boolean isAbstract = false;
        if (input.startsWith("<abstract> ")) {
            isAbstract = true;
            input = input.substring(11).trim();
        }
        if (input.contains(" is ")) {
            type = input.split(" is ")[0].trim();
            superType = input.split(" is ")[1].trim();
        } else {
            type = input.trim();
        }
        if ("<root>".equals(type)) {
            return Entity.root();
        }
        ModelDescriptorParser.checkEntityName(type);
        return new Entity(type, superType, new ArrayList<Attribute>(), isAbstract);
    }

    private static void checkAttributeName(String attributeName) {
        if (!attributeName.matches("[a-z][a-zA-Z0-9]*")) {
            throw new IllegalArgumentException("Invalid attribute name: " + attributeName);
        }
    }

    private static void checkEntityName(String entityName) {
        if (!entityName.matches("[A-Z][a-zA-Z0-9]*")) {
            throw new IllegalArgumentException("Invalid entity name: " + entityName);
        }
    }
}

