/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.it.datasetbuilder.apibuilder.Attribute;
import org.squashtest.it.datasetbuilder.apibuilder.Entity;
import org.squashtest.it.datasetbuilder.apibuilder.EnumParser;
import org.squashtest.it.datasetbuilder.apibuilder.ModelType;

public class JsonSchemaGenerator {
    private static final String DISCRIMINATOR_NAME = "kind";
    private static final String DEFINITIONS = "#/definitions/";
    private static final String TYPE = "type";
    private static final String REF = "$ref";
    private final ObjectMapper mapper = new ObjectMapper();
    private final List<Entity> entityTypes;

    public JsonSchemaGenerator(List<Entity> entityTypes) {
        this.entityTypes = entityTypes;
    }

    public String generateSchema() throws JsonProcessingException {
        ObjectNode rootSchema = this.mapper.createObjectNode();
        rootSchema.put("$schema", "http://json-schema.org/draft-07/schema#");
        rootSchema.put("additionalProperties", false);
        ObjectNode definitions = rootSchema.putObject("definitions");
        for (Entity type : this.entityTypes) {
            if (type.isRoot()) continue;
            definitions.set(type.name(), (JsonNode)this.generateTypeDefinition(type));
        }
        Entity rootEntity = this.entityTypes.stream().filter(Entity::isRoot).findFirst().orElseThrow(() -> new IllegalStateException("Root entity not found"));
        ObjectNode properties = this.generateProperties(rootEntity, false);
        rootSchema.setAll(properties);
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootSchema);
    }

    private List<Entity> findSubTypes(Entity type) {
        return this.entityTypes.stream().filter(subType -> subType.superType() != null && subType.superType().equals(type.name())).toList();
    }

    private List<Attribute> findAllAttributes(Entity type) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(type.attributes());
        if (type.superType() != null) {
            Entity superType = this.entityTypes.stream().filter(t -> t.name().equals(type.superType())).findFirst().orElseThrow();
            List<Attribute> superAttributes = this.findAllAttributes(superType);
            attributes.addAll(superAttributes);
        }
        return attributes;
    }

    private ObjectNode generateTypeDefinition(Entity type) {
        ObjectNode schema = this.mapper.createObjectNode();
        schema.put("additionalProperties", false);
        if (type.isAbstract()) {
            ArrayNode oneOf = schema.putArray("oneOf");
            List<Entity> subTypes = this.findSubTypes(type);
            if (subTypes.isEmpty()) {
                throw new IllegalStateException("Abstract type " + type.name() + " has no subtypes");
            }
            subTypes.stream().map(subType -> {
                ObjectNode ref = this.mapper.createObjectNode();
                ref.put(REF, DEFINITIONS + subType.name());
                return ref;
            }).forEach(arg_0 -> ((ArrayNode)oneOf).add(arg_0));
        } else {
            schema.put(TYPE, "object");
            ObjectNode properties = this.generateProperties(type);
            schema.setAll(properties);
        }
        return schema;
    }

    private ObjectNode generateProperties(Entity type) {
        return this.generateProperties(type, true);
    }

    private ObjectNode generateProperties(Entity type, boolean includeDiscriminator) {
        ObjectNode schema = this.mapper.createObjectNode();
        schema.put(TYPE, "object");
        ObjectNode properties = schema.putObject("properties");
        ArrayNode required = schema.putArray("required");
        if (!type.isAbstract() && includeDiscriminator) {
            ObjectNode typeProperty = properties.putObject(DISCRIMINATOR_NAME);
            typeProperty.put("const", type.name());
        }
        List<Attribute> attributes = this.findAllAttributes(type);
        for (Attribute attr : attributes) {
            this.addAttribute(attr, properties, required);
        }
        return schema;
    }

    private void addAttribute(Attribute attr, ObjectNode properties, ArrayNode required) {
        ObjectNode property = properties.putObject(attr.name());
        if (attr.isMany()) {
            property.put(TYPE, "array");
            ObjectNode items = property.putObject("items");
            this.addType(items, attr);
        } else {
            this.addType(property, attr);
        }
        if (this.isRequired(attr)) {
            required.add(attr.name());
        }
    }

    private void addType(ObjectNode objectNode, Attribute attr) {
        ModelType modelType = attr.type();
        switch (attr.type().getKind()) {
            case REF: {
                objectNode.put(modelType.getJsonType(), DEFINITIONS + modelType.getType());
                break;
            }
            case ENUM: {
                ArrayNode arrayNode = objectNode.putArray(modelType.getJsonType());
                EnumParser.getEnumConstants(modelType.getEnumFullyQualifiedName()).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
                break;
            }
            case ANY: {
                objectNode.putObject(modelType.getJsonType());
                break;
            }
            default: {
                objectNode.put(modelType.getJsonType(), modelType.getJsonAttributeType());
            }
        }
    }

    private boolean isRequired(Attribute attribute) {
        if (attribute.cardinality().isOptional()) {
            return false;
        }
        return attribute.defaultValue() == null;
    }
}

