/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder;

import org.squashtest.it.datasetbuilder.apibuilder.EnumParser;
import org.squashtest.it.datasetbuilder.apibuilder.ValuePlaceholder;

public record DefaultValue(Type type, Object value) {
    public static DefaultValue ofPlaceholder(String value) {
        return new DefaultValue(Type.PLACEHOLDER, (Object)ValuePlaceholder.parsePlaceholder(value));
    }

    public static DefaultValue ofString(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return new DefaultValue(Type.STRING, value);
    }

    public static DefaultValue ofBoolean(String value) {
        return new DefaultValue(Type.BOOLEAN, Boolean.parseBoolean(value));
    }

    public static DefaultValue ofLong(String value) {
        try {
            return new DefaultValue(Type.LONG, Long.parseLong(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid long value: " + value);
        }
    }

    public static DefaultValue ofInt(String value) {
        try {
            return new DefaultValue(Type.INTEGER, Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid int value: " + value);
        }
    }

    public static DefaultValue ofEnum(String value) {
        DefaultValue.parseEnum(value);
        return new DefaultValue(Type.ENUM, value);
    }

    private static <E extends Enum<E>> E parseEnum(String value) {
        int lastDotIndex = value.lastIndexOf(46);
        String enumClassName = value.substring(0, lastDotIndex);
        String enumValueName = value.substring(lastDotIndex + 1);
        return EnumParser.parseEnum(enumClassName, enumValueName);
    }

    public String getMarkdownDescription() {
        return switch (this.type) {
            case Type.NULL -> "`null`";
            case Type.STRING -> "`\"%s\"`".formatted(this.value);
            case Type.INTEGER, Type.LONG, Type.BOOLEAN -> "`" + String.valueOf(this.value) + "`";
            case Type.ENUM -> {
                Object enumValue = DefaultValue.parseEnum((String)this.value);
                yield "`" + enumValue.getClass().getSimpleName() + "." + ((Enum)enumValue).name() + "`";
            }
            case Type.PLACEHOLDER -> ((ValuePlaceholder)((Object)this.value)).markdownDescription;
            default -> throw new MatchException(null, null);
        };
    }

    public String getJavaTemplate() {
        return switch (this.type) {
            case Type.NULL -> "null";
            case Type.STRING -> "\"" + String.valueOf(this.value) + "\"";
            case Type.INTEGER, Type.BOOLEAN -> String.valueOf(this.value);
            case Type.LONG -> String.valueOf(this.value) + "L";
            case Type.ENUM -> this.value.toString();
            case Type.PLACEHOLDER -> ((ValuePlaceholder)((Object)this.value)).javaTemplate;
            default -> throw new MatchException(null, null);
        };
    }

    public static enum Type {
        NULL,
        STRING,
        INTEGER,
        LONG,
        BOOLEAN,
        ENUM,
        PLACEHOLDER;

    }
}

