/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder.java;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.it.datasetbuilder.apibuilder.Attribute;
import org.squashtest.it.datasetbuilder.apibuilder.Entity;
import org.squashtest.it.datasetbuilder.apibuilder.ModelType;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class JavaModelGenerator {
    private static final String ROOT_ENTITY_NAME = "SquashModel";
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaModelGenerator.class);
    private static final String CLOSE_METHOD = "    }\n\n";
    private static final String PUBLIC = "    public ";
    private final List<Entity> entities;
    private final String packageName;
    private final String outputDirectory;

    public JavaModelGenerator(List<Entity> entities, String packageName, String outputDirectory) {
        this.entities = entities;
        this.packageName = packageName;
        this.outputDirectory = outputDirectory;
    }

    public void generateModels() throws IOException {
        for (Entity entity : this.entities) {
            this.generateModel(entity);
        }
    }

    private void generateModel(Entity entity) throws IOException {
        List<Attribute> allAttributes = this.findAllAttributes(entity);
        StringBuilder content = new StringBuilder();
        String builderName = JavaModelGenerator.getBuilderName(entity);
        content.append("package ").append(this.packageName).append(";\n\n");
        JavaModelGenerator.appendImports(entity, allAttributes, content);
        if (entity.isAbstract()) {
            content.append("@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = \"kind\")\n").append("@JsonSubTypes({\n");
            for (Entity subType : this.entities) {
                if (subType.superType() == null || !subType.superType().equals(entity.name())) continue;
                content.append("    @JsonSubTypes.Type(value = ").append(JavaModelGenerator.getBuilderName(subType.name())).append(".class, name = \"").append(subType.name()).append("\"),\n");
            }
            content.append("})\n");
        }
        content.append("public ");
        if (entity.isAbstract()) {
            content.append("abstract ");
        }
        content.append("class ").append(builderName);
        if (entity.superType() != null) {
            content.append(" extends ").append(JavaModelGenerator.getBuilderName(entity.superType()));
        }
        content.append(" {\n");
        content.append("    protected String kind;\n");
        this.appendOwnAttributes(entity, content);
        content.append("\n");
        if (!entity.isAbstract()) {
            this.appendFactoryMethod(entity, content, builderName);
        }
        content.append("    public String getKind() {\n").append("        return kind;\n").append(CLOSE_METHOD);
        for (Attribute attribute : allAttributes) {
            this.appendPropertyMethods(entity, attribute, content, builderName);
        }
        content.append("}\n");
        Path path = Path.of(this.outputDirectory, new String[0]).resolve(this.packageName.replace(".", "/")).resolve(builderName + ".java");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, content.toString().getBytes(), new OpenOption[0]);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Generated: %s".formatted(path), new Object[0]);
        }
    }

    private static void appendImports(Entity entity, List<Attribute> allAttributes, StringBuilder content) {
        if (allAttributes.stream().anyMatch(Attribute::isMany)) {
            content.append("import java.util.List;\n");
        }
        if (entity.isAbstract()) {
            content.append("import com.fasterxml.jackson.annotation.JsonSubTypes;\n").append("import com.fasterxml.jackson.annotation.JsonTypeInfo;\n");
        }
        content.append("\n");
    }

    private void appendOwnAttributes(Entity entity, StringBuilder content) {
        for (Attribute attribute : entity.attributes()) {
            content.append("    protected ").append(this.toArgType(attribute)).append(" ").append(attribute.name());
            if (attribute.defaultValue() != null) {
                content.append(" = ").append(attribute.defaultValue().getJavaTemplate());
            } else if (attribute.isMany()) {
                content.append(" = List.of()");
            }
            content.append(";\n");
        }
    }

    private void appendFactoryMethod(Entity entity, StringBuilder content, String builderName) {
        content.append("    public static ").append(builderName).append(" ").append(entity.isRoot() ? "squash" : this.toLowerCamelCase(entity.name())).append("() {\n").append("        return new ").append(builderName).append("();\n").append(CLOSE_METHOD);
    }

    private void appendPropertyMethods(Entity entity, Attribute attribute, StringBuilder content, String builderName) {
        boolean isOwnAttribute = entity.attributes().contains(attribute);
        if (isOwnAttribute) {
            content.append(PUBLIC).append(this.toArgType(attribute)).append(" ").append("get").append(JavaModelGenerator.toCapitalized(attribute.name())).append("() {\n").append("        return ").append(attribute.name()).append(";\n").append(CLOSE_METHOD);
        }
        if (!entity.isAbstract()) {
            content.append(PUBLIC).append(builderName).append(" with").append(JavaModelGenerator.toCapitalized(attribute.name())).append("(").append(this.toArgType(attribute)).append(" ").append(attribute.name()).append(") {\n");
            content.append("        this.").append(attribute.name()).append(" = ").append(attribute.name()).append(";\n");
            content.append("        return this;\n");
            content.append(CLOSE_METHOD);
            if (attribute.isMany()) {
                content.append(PUBLIC).append(builderName).append(" with").append(JavaModelGenerator.toCapitalized(attribute.name())).append("(").append(this.toJavaType(attribute.type())).append("... ").append(attribute.name()).append(") {\n");
                content.append("        this.").append(attribute.name()).append(" = List.of(").append(attribute.name()).append(");\n");
                content.append("        return this;\n");
                content.append(CLOSE_METHOD);
            }
        }
    }

    private List<Attribute> findAllAttributes(Entity entity) {
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        if (entity.superType() != null) {
            Entity superType = this.entities.stream().filter(e -> e.name().equals(entity.superType())).findFirst().orElseThrow();
            allAttributes.addAll(this.findAllAttributes(superType));
        }
        allAttributes.addAll(entity.attributes());
        return allAttributes;
    }

    private String toLowerCamelCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private static String toCapitalized(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private String toArgType(Attribute attribute) {
        if (attribute.isMany()) {
            return "List<" + this.toJavaType(attribute.type()) + ">";
        }
        return this.toJavaType(attribute.type());
    }

    private String toJavaType(ModelType type) {
        if (this.isKnownEntityType(type.getType())) {
            return JavaModelGenerator.getBuilderName(type.getType());
        }
        return type.getJavaType();
    }

    private boolean isKnownEntityType(String type) {
        return this.entities.stream().anyMatch(e -> e.name().equals(type));
    }

    private static String getBuilderName(Entity entity) {
        if (entity.isRoot()) {
            return ROOT_ENTITY_NAME;
        }
        return JavaModelGenerator.getBuilderName(entity.name());
    }

    private static String getBuilderName(String entityName) {
        return entityName + "Model";
    }
}

