/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.squashtest.it.datasetbuilder.apibuilder.EnumParser;

public class ModelType {
    private static final String INTEGER_JSON_TYPE = "integer";
    private static final Pattern TYPE_PATTERN = Pattern.compile("^(\\w+)(?:\\(([^)]+)\\))?(?:\\[(.*)])?$");
    private final Kind kind;
    private final String type;
    private final String enumFullyQualifiedName;
    private final String typeCardinality;

    public ModelType(Kind kind, String type, String enumFullyQualifiedName, String typeCardinality) {
        this.kind = kind;
        this.type = type;
        this.enumFullyQualifiedName = enumFullyQualifiedName;
        this.typeCardinality = typeCardinality;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeCardinality() {
        return this.typeCardinality;
    }

    public String getEnumFullyQualifiedName() {
        return this.enumFullyQualifiedName;
    }

    public String getJavaType() {
        if (this.kind.javaType == null) {
            String existingType = Arrays.stream(Kind.values()).map(value -> value.javaType).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("No Java type for %s in %s", this.type, existingType));
        }
        return Objects.requireNonNullElseGet(this.enumFullyQualifiedName, () -> this.kind.javaType);
    }

    public String getJsonType() {
        return this.kind.jsonType;
    }

    public String getJsonAttributeType() {
        return this.kind.jsonAttributeType;
    }

    public String getMarkdownType() {
        return switch (this.kind) {
            case Kind.ENUM -> EnumParser.getEnumClass(this.enumFullyQualifiedName).getSimpleName();
            case Kind.REF -> this.type;
            default -> this.kind.javaType;
        };
    }

    public static ModelType fromModel(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Missing type");
        }
        Matcher typeMatcher = TYPE_PATTERN.matcher(type);
        if (!typeMatcher.find()) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        Kind modelTypeKind = Kind.fromModelType(typeMatcher.group(1));
        return new ModelType(modelTypeKind, typeMatcher.group(1), typeMatcher.group(2), typeMatcher.group(3));
    }

    public static enum Kind {
        STRING("String", "type", "string"),
        INTEGER("Integer", "type", "integer"),
        LONG("Long", "type", "integer"),
        INT("Integer", "type", "integer"),
        BOOLEAN("boolean", "type", "boolean"),
        OBJECT("Object", "type", "object"),
        ANY("Object", "type", "{}"),
        FLOAT("Float", "type", "number"),
        ENUM("enum", "enum", "enum"),
        REF(null, "$ref", "ref");

        final String javaType;
        final String jsonAttributeType;
        final String jsonType;

        private Kind(String javaType, String jsonType, String jsonAttributeType) {
            this.javaType = javaType;
            this.jsonType = jsonType;
            this.jsonAttributeType = jsonAttributeType;
        }

        public static Kind fromModelType(String modelType) {
            return Arrays.stream(Kind.values()).filter(value -> modelType.equalsIgnoreCase(value.name())).findFirst().orElse(REF);
        }
    }
}

