/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.apibuilder;

public enum ValuePlaceholder {
    NULL("<null>", "`null`", "null"),
    TRUE("<true>", "`true`", "true"),
    FALSE("<false>", "`false`", "false"),
    TODAY("<today>", "today's date", "java.time.LocalDate.now().toString()"),
    UUID("<uuid>", "a random UUID", "java.util.UUID.randomUUID().toString()");

    public final String placeholder;
    public final String markdownDescription;
    public final String javaTemplate;

    private ValuePlaceholder(String placeholder, String markdownDescription, String javaTemplate) {
        this.placeholder = placeholder;
        this.markdownDescription = markdownDescription;
        this.javaTemplate = javaTemplate;
    }

    public static boolean isPlaceholder(String value) {
        ValuePlaceholder[] valuePlaceholderArray = ValuePlaceholder.values();
        int n = valuePlaceholderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValuePlaceholder valuePlaceholder = valuePlaceholderArray[n2];
            if (valuePlaceholder.placeholder.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ValuePlaceholder parsePlaceholder(String placeholder) {
        ValuePlaceholder[] valuePlaceholderArray = ValuePlaceholder.values();
        int n = valuePlaceholderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValuePlaceholder valuePlaceholder = valuePlaceholderArray[n2];
            if (valuePlaceholder.placeholder.equals(placeholder)) {
                return valuePlaceholder;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown value placeholder: " + placeholder);
    }
}

