/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.extract.attachment.tool.engine.jobs.verify;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.CompositeItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.Attachment;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.ExtractJobConfig;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.verify.NoOpItemWriter;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.verify.VerifyProcessor;

@Configuration
@Import(value={ExtractJobConfig.class})
public class VerifyJobConfig {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private JobBuilderFactory jobFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    @Qualifier(value="attachmentItemReader")
    private ItemReader<Attachment> attachmentItemReader;
    @Autowired
    @Qualifier(value="attachmentItemProcessor")
    private ItemProcessor<Attachment, Attachment> attachmentItemProcessor;

    @Bean
    public Job verifyJob() {
        return this.jobFactory.get("verifyJob").start(this.verifyStep()).build();
    }

    @Bean
    public Step verifyStep() {
        return this.stepBuilderFactory.get("VerifyStep").chunk(500).reader(this.attachmentItemReader).processor((ItemProcessor)this.compositeItemProcessor(this.verifyProcessor())).writer(this.noopWriter()).build();
    }

    @Bean
    public ItemProcessor<Attachment, Attachment> verifyProcessor() {
        return new VerifyProcessor();
    }

    @Bean
    public ItemWriter<Attachment> noopWriter() {
        return new NoOpItemWriter();
    }

    @Bean
    @StepScope
    public CompositeItemProcessor<Attachment, Attachment> compositeItemProcessor(ItemProcessor<Attachment, Attachment> verifyProcessor) {
        CompositeItemProcessor composite = new CompositeItemProcessor();
        ArrayList<Object> itemProcessors = new ArrayList<Object>();
        itemProcessors.add(this.attachmentItemProcessor);
        itemProcessors.add(verifyProcessor);
        composite.setDelegates(itemProcessors);
        return composite;
    }
}

