/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.extract.attachment.tool.engine.jobs.extract;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.Attachment;

public class AttachmentItemWriter
implements ItemWriter<Attachment> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentItemWriter.class);

    public void write(List<? extends Attachment> attachments) throws Exception {
        for (Attachment attachment : attachments) {
            if (attachment.getContent() != null) {
                LOGGER.info("Attachment content : {} Size : {} Path will be {}", new Object[]{attachment.getAttachmentContentId(), attachment.getContent().length, attachment.getPath()});
                File file = new File(attachment.getPath());
                FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(attachment.getContent()), (File)file);
                continue;
            }
            LOGGER.warn("Attachment content : {} has null stream content", (Object)attachment.getAttachmentContentId());
        }
    }
}

