/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.extract.attachment.tool.engine.jobs.verify;

import java.io.File;
import java.security.MessageDigest;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemProcessor;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.Attachment;

public class VerifyProcessor
implements ItemProcessor<Attachment, Attachment> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyProcessor.class);

    public Attachment process(Attachment attachment) throws Exception {
        if (attachment.getContent() != null) {
            byte[] databaseContent;
            String path = attachment.getPath();
            byte[] fileContent = FileUtils.readFileToByteArray((File)new File(path));
            boolean equal = MessageDigest.isEqual(fileContent, databaseContent = attachment.getContent());
            if (equal) {
                LOGGER.info("Attachment {} and file {} are equals.", (Object)attachment.getAttachmentContentId(), (Object)attachment.getPath());
            } else {
                String msg = String.format("Copy error for attachment content %d in attachment list %d. The database content is not identical to the file content for file %s. Check your parameters, disk size, permissions... and retry the whole migration process", attachment.getAttachmentContentId(), attachment.getAttachmentListId(), attachment.getPath());
                throw new RuntimeException(msg);
            }
        }
        return attachment;
    }
}

