/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.extract.attachment.tool.engine.jobs.extract;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.squashtest.tm.extract.attachment.tool.engine.jobs.extract.Attachment;

public class AttachmentProcessor
implements ItemProcessor<Attachment, Attachment> {
    private static final String SEPARATOR = File.separator;
    @Value(value="#{jobParameters[fileRepo]}")
    private String fileRepo;

    public Attachment process(Attachment attachment) throws Exception {
        attachment.setPath(this.getAttachmentPath(attachment.getAttachmentContentId(), attachment.getAttachmentListId()));
        return attachment;
    }

    private String getAttachmentPath(Long contentId, Long attachmentListId) {
        String folderPath = this.findFolderPath(attachmentListId.longValue());
        return folderPath + contentId;
    }

    private String findFolderPath(long attachmentListId) {
        String id = String.valueOf(attachmentListId);
        String paddedId = StringUtils.leftPad((String)id, (int)12, (String)"0");
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(paddedId.substring(0, 3));
        parts.add(paddedId.substring(3, 6));
        parts.add(paddedId.substring(6, 9));
        parts.add(paddedId.substring(9, 12));
        Object path = StringUtils.join(parts, (String)SEPARATOR);
        String checkedFileRepo = StringUtils.appendIfMissing((String)this.fileRepo, (CharSequence)SEPARATOR, (CharSequence[])new CharSequence[0]);
        path = checkedFileRepo + (String)path;
        return StringUtils.appendIfMissing((String)path, (CharSequence)SEPARATOR, (CharSequence[])new CharSequence[0]);
    }
}

