/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.extract.attachment.tool.engine;

import java.util.Date;
import java.util.HashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ExecutionEngine {
    @Value(value="${squash.path.file.repository}")
    private String fileRepo;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionEngine.class);
    @Autowired
    private JobLauncher jobLauncher;
    @Autowired
    @Qualifier(value="extractAttachment")
    private Job extractAttachmentJob;
    @Autowired
    @Qualifier(value="verifyJob")
    private Job verifyJob;
    @Autowired
    @Qualifier(value="deletionJob")
    private Job deletionJob;
    @Autowired
    private DataSource dataSource;

    public void runMainJobMigration() throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        JobExecution extractJobExecution = this.executeExtractJob();
        if (extractJobExecution.getStatus().equals((Object)BatchStatus.COMPLETED)) {
            LOGGER.info("################ Attachments copied to system file. Proceeding to verifications before deletion in database. ################");
            JobExecution verifyJobExecution = this.executeVerifyJob();
            if (verifyJobExecution.getStatus().equals((Object)BatchStatus.COMPLETED)) {
                LOGGER.info("################ Attachments checked. Proceeding to deletion in database. ################");
                JobExecution deletionJobExecution = this.executeDeletionJob();
                if (deletionJobExecution.getStatus().equals((Object)BatchStatus.COMPLETED)) {
                    LOGGER.info("################ Migration complete ################");
                } else {
                    LOGGER.error("################ Error while deleting attachment from database ################");
                }
            }
        }
    }

    private JobExecution executeExtractJob() throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        JobParameters jobParameters = this.getJobParameters();
        return this.jobLauncher.run(this.extractAttachmentJob, jobParameters);
    }

    private JobExecution executeVerifyJob() throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        JobParameters jobParameters = this.getJobParameters();
        return this.jobLauncher.run(this.verifyJob, jobParameters);
    }

    private JobExecution executeDeletionJob() throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        JobParameters jobParameters = this.getJobParameters();
        return this.jobLauncher.run(this.deletionJob, jobParameters);
    }

    private JobParameters getJobParameters() {
        HashMap<String, JobParameter> params = new HashMap<String, JobParameter>();
        params.put("fileRepo", new JobParameter(this.fileRepo));
        params.put("executionDate", new JobParameter(new Date()));
        return new JobParameters(params);
    }
}

