/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class DateFormatters {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private DateFormatters() {
        throw new AssertionError((Object)"This class should not be instantiated");
    }

    public static String shortDate(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMATTER.format(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
    }

    public static Date parseShortDate(String date) {
        if (date == null) {
            return null;
        }
        LocalDate localDate = LocalDate.parse(date, DATE_FORMATTER);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }
}

