/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.squashtest.it.datasetbuilder.DatasetBuilder;
import org.squashtest.it.datasetbuilder.api.model.ActionTestStepModel;
import org.squashtest.it.datasetbuilder.api.model.CallTestStepModel;
import org.squashtest.it.datasetbuilder.api.model.ProjectModel;
import org.squashtest.it.datasetbuilder.api.model.StandardTestCaseModel;
import org.squashtest.it.datasetbuilder.api.model.TestCaseLibraryNodeModel;
import org.squashtest.it.datasetbuilder.api.model.TestStepModel;
import org.squashtest.it.datasetbuilder.mappers.ProjectMapper;
import org.squashtest.it.datasetbuilder.rowbuilders.AttachmentListRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CampaignLibraryNodeRow;
import org.squashtest.it.datasetbuilder.rowbuilders.CampaignLibraryRow;
import org.squashtest.it.datasetbuilder.rowbuilders.ProjectRow;
import org.squashtest.it.datasetbuilder.rowbuilders.SprintGroupRow;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class Example {
    private static final Logger LOGGER = LoggerFactory.getLogger(Example.class);

    public static void main(String[] args) throws IOException {
        String result = DatasetBuilder.build(AttachmentListRow.builder().withAttachmentListId((Object)-555).build().toTableRow(), AttachmentListRow.builder().withAttachmentListId((Object)-988).build().toTableRow(), CampaignLibraryRow.builder().withClId((Object)-1).withAttachmentListId((Object)-988).build().toTableRow(), ProjectRow.builder().withProjectId((Object)-1).withAttachmentListId((Object)-555).withCreatedOn((Object)"2012-02-01").withCreatedBy((Object)"DBU").withName((Object)"pro").withClId((Object)-1).build().toTableRow(), AttachmentListRow.builder().withAttachmentListId((Object)-123).build().toTableRow(), CampaignLibraryNodeRow.builder().withClnId((Object)-1).withName((Object)"a sprint group").withCreatedOn((Object)"2010-02-01").withCreatedBy((Object)"DBU").withAttachmentListId((Object)-123).withProjectId((Object)-1).withLastModifiedBy((Object)"DBU").withLastModifiedOn((Object)"2024-01-17").build().toTableRow(), SprintGroupRow.builder().withClnId((Object)-1).build().toTableRow());
        Example.writeToFile(result, Path.of("target/datasets/example01.xml", new String[0]));
        String[] result2 = DatasetBuilder.build(ProjectMapper.toDatasetData(ProjectModel.project().withProjectId(Long.valueOf(-1L)).withTestCaseLibraryNodes(new TestCaseLibraryNodeModel[]{StandardTestCaseModel.standardTestCase().withTclnId(Long.valueOf(-1L)).withName("test1").withSteps(new TestStepModel[]{ActionTestStepModel.actionTestStep().withStepId(Long.valueOf(-1L))}), StandardTestCaseModel.standardTestCase().withTclnId(Long.valueOf(-2L)).withSteps(new TestStepModel[]{CallTestStepModel.callTestStep().withStepId(Long.valueOf(-2L)).withCalledTestCaseId(Long.valueOf(-1L))})})));
        Example.writeToFile(result2[0], Path.of("target/datasets/example02.xml", new String[0]));
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        ProjectModel projectModel = (ProjectModel)yamlMapper.readValue("_kind: Project\nname: \"pro\"\ncreatedOn: \"2012-02-01\"\ncreatedBy: \"DBU\"\ntestCaseLibraryNodes:\n  - _kind: StandardTestCase\n    id: -1\n    name: \"test1\"\n    steps:\n      - _kind: ActionTestStep\n  - _kind: StandardTestCase\n    id: -2\n    steps:\n      - _kind: CallTestStep\n        id: -1\n        calledTestCaseId: -1\n", ProjectModel.class);
        String[] result3 = DatasetBuilder.build(ProjectMapper.toDatasetData(projectModel));
        Example.writeToFile(result3[0], Path.of("target/datasets/example03.xml", new String[0]));
    }

    private static void writeToFile(String content, Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, content.getBytes(), new OpenOption[0]);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Dataset written to: %s%n%s".formatted(path, content), new Object[0]);
        }
    }
}

