/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.api.model.AiServerModel;
import org.squashtest.it.datasetbuilder.api.model.BugTrackerModel;
import org.squashtest.it.datasetbuilder.api.model.ScmServerModel;
import org.squashtest.it.datasetbuilder.api.model.TestAutomationServerModel;
import org.squashtest.it.datasetbuilder.api.model.ThirdPartyServerModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderAdminWsEntities;

public final class ServerMapper {
    private ServerMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(ThirdPartyServerModel model) {
        DatasetData datasetData = new DatasetData();
        datasetData.addTableRowInsert(BuilderAdminWsEntities.getThirdPartyServerTableRow(model));
        ThirdPartyServerModel thirdPartyServerModel = model;
        Objects.requireNonNull(thirdPartyServerModel);
        ThirdPartyServerModel thirdPartyServerModel2 = thirdPartyServerModel;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ScmServerModel.class, TestAutomationServerModel.class, AiServerModel.class, BugTrackerModel.class}, (Object)thirdPartyServerModel2, n)) {
            case 0: {
                ScmServerModel scmServerModel = (ScmServerModel)thirdPartyServerModel2;
                ServerMapper.mapScmServer(scmServerModel, datasetData);
                break;
            }
            case 1: {
                TestAutomationServerModel taServerModel = (TestAutomationServerModel)thirdPartyServerModel2;
                datasetData.addTableRowInsert(BuilderAdminWsEntities.getTestAutomationServerTableRow(taServerModel));
                break;
            }
            case 2: {
                AiServerModel aiServerModel = (AiServerModel)thirdPartyServerModel2;
                datasetData.addTableRowInsert(BuilderAdminWsEntities.getAiServerTableRow(aiServerModel));
                break;
            }
            case 3: {
                BugTrackerModel bugTrackerServerModel = (BugTrackerModel)thirdPartyServerModel2;
                datasetData.addTableRowInsert(BuilderAdminWsEntities.getBugtrackerTableRow(bugTrackerServerModel));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported server model: " + String.valueOf(model.getClass()));
            }
        }
        return datasetData;
    }

    private static void mapScmServer(ScmServerModel model, DatasetData datasetData) {
        datasetData.addTableRowInsert(BuilderAdminWsEntities.getScmServerTableRow(model));
        model.getRepositories().forEach(repoModel -> datasetData.addTableRowInsert(BuilderAdminWsEntities.getScmRepositoryTableRow(repoModel, model.getId())));
    }
}

