/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.datasetbuilder.mappers;

import org.squashtest.it.datasetbuilder.DatasetData;
import org.squashtest.it.datasetbuilder.api.model.QuickTestModel;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderAdminWsEntities;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderExecutionWs;
import org.squashtest.it.datasetbuilder.entitybuilder.BuilderGlobalEntities;
import org.squashtest.it.datasetbuilder.rowbuilders.AttachmentListRow;
import org.squashtest.it.datasetbuilder.rowbuilders.IssueListRow;
import org.squashtest.it.datasetbuilder.rowbuilders.IssueRow;

public final class QuickTestMapper {
    private QuickTestMapper() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static DatasetData toDatasetData(QuickTestModel model) {
        DatasetData datasetData = new DatasetData();
        Long attachmentListId = AttachmentListRow.sequence.nextId();
        Long issueListId = IssueListRow.sequence.nextId();
        datasetData.addTableRowInsert(BuilderGlobalEntities.getAttachmentListTableRow(attachmentListId), BuilderExecutionWs.getIssueListTableRow(issueListId));
        datasetData.addTableRowInsert(BuilderAdminWsEntities.getQuickTestTableRow(model, attachmentListId, issueListId));
        if (model.getIssues() != null) {
            model.getIssues().forEach(i -> datasetData.addTableRowInsert(BuilderExecutionWs.getIssueTableRow(i, IssueRow.sequence.nextId(), issueListId)));
        }
        return datasetData;
    }
}

